/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.json.JsonValue;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryScanConsistency;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.query.N1QLExpression;
import org.springframework.data.couchbase.core.query.N1QLQuery;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.util.StreamUtils;

public abstract class AbstractN1qlBasedQuery
implements RepositoryQuery {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractN1qlBasedQuery.class);
    protected final CouchbaseQueryMethod queryMethod;
    private final CouchbaseOperations couchbaseOperations;

    protected AbstractN1qlBasedQuery(CouchbaseQueryMethod queryMethod, CouchbaseOperations couchbaseOperations) {
        this.queryMethod = queryMethod;
        this.couchbaseOperations = couchbaseOperations;
    }

    protected static N1QLQuery buildQuery(N1QLExpression expression, JsonValue queryPlaceholderValues, QueryScanConsistency scanConsistency) {
        QueryOptions opts = QueryOptions.queryOptions().scanConsistency(scanConsistency);
        if (queryPlaceholderValues instanceof JsonObject && !((JsonObject)queryPlaceholderValues).isEmpty()) {
            opts.parameters((JsonObject)queryPlaceholderValues);
        } else if (queryPlaceholderValues instanceof JsonArray && !((JsonArray)queryPlaceholderValues).isEmpty()) {
            opts.parameters((JsonArray)queryPlaceholderValues);
        }
        return new N1QLQuery(expression, opts);
    }

    protected abstract N1QLExpression getCount(ParameterAccessor var1, Object[] var2);

    protected abstract boolean useGeneratedCountQuery();

    protected abstract N1QLExpression getExpression(ParameterAccessor var1, Object[] var2, ReturnedType var3);

    protected abstract JsonValue getPlaceholderValues(ParameterAccessor var1);

    protected QueryScanConsistency getScanConsistency() {
        return QueryScanConsistency.REQUEST_PLUS;
    }

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        ResultProcessor processor = this.queryMethod.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        ReturnedType returnedType = processor.getReturnedType();
        Class typeToRead = this.queryMethod.getEntityInformation().getJavaType();
        N1QLExpression statement = this.getExpression((ParameterAccessor)accessor, parameters, returnedType);
        JsonValue queryPlaceholderValues = this.getPlaceholderValues((ParameterAccessor)accessor);
        N1QLQuery query = AbstractN1qlBasedQuery.buildQuery(statement, queryPlaceholderValues, this.getScanConsistency());
        N1QLExpression countStatement = this.getCount((ParameterAccessor)accessor, parameters);
        N1QLQuery countQuery = AbstractN1qlBasedQuery.buildQuery(countStatement, queryPlaceholderValues, this.getScanConsistency());
        return processor.processResult(this.executeDependingOnType(query, countQuery, this.queryMethod, accessor.getPageable(), typeToRead));
    }

    protected Object executeDependingOnType(N1QLQuery query, N1QLQuery countQuery, QueryMethod queryMethod, Pageable pageable, Class<?> typeToRead) {
        if (queryMethod.isPageQuery()) {
            return this.executePaged(query, countQuery, pageable, typeToRead);
        }
        if (queryMethod.isSliceQuery()) {
            return this.executeSliced(query, countQuery, pageable, typeToRead);
        }
        if (queryMethod.isCollectionQuery()) {
            return this.executeCollection(query, typeToRead);
        }
        if (queryMethod.isStreamQuery()) {
            return this.executeStream(query, typeToRead);
        }
        if (queryMethod.isQueryForEntity()) {
            return this.executeEntity(query, typeToRead);
        }
        if (queryMethod.getReturnedObjectType().isPrimitive() && this.useGeneratedCountQuery()) {
            return this.executeSingleProjection(countQuery);
        }
        return this.executeSingleProjection(query);
    }

    private void logIfNecessary(N1QLQuery query) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing N1QL query: " + String.valueOf(query.n1ql()));
        }
    }

    protected List<?> executeCollection(N1QLQuery query, Class<?> typeToRead) {
        throw new UnsupportedOperationException("TODO");
    }

    protected Object executeEntity(N1QLQuery query, Class<?> typeToRead) {
        this.logIfNecessary(query);
        List<?> result = this.executeCollection(query, typeToRead);
        return result.isEmpty() ? null : result.get(0);
    }

    protected Object executeStream(N1QLQuery query, Class<?> typeToRead) {
        this.logIfNecessary(query);
        return StreamUtils.createStreamFromIterator(this.executeCollection(query, typeToRead).iterator());
    }

    protected Object executePaged(N1QLQuery query, N1QLQuery countQuery, Pageable pageable, Class<?> typeToRead) {
        throw new UnsupportedOperationException("TODO");
    }

    protected Object executeSliced(N1QLQuery query, N1QLQuery countQuery, Pageable pageable, Class<?> typeToRead) {
        throw new UnsupportedOperationException("TODO");
    }

    protected Object executeSingleProjection(N1QLQuery query) {
        throw new UnsupportedOperationException("TODO");
    }

    public CouchbaseQueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    protected CouchbaseOperations getCouchbaseOperations() {
        return this.couchbaseOperations;
    }
}

