/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.cache.Cache;
import org.springframework.cache.transaction.AbstractTransactionSupportingCacheManager;
import org.springframework.data.couchbase.CouchbaseClientFactory;
import org.springframework.data.couchbase.cache.CouchbaseCache;
import org.springframework.data.couchbase.cache.CouchbaseCacheConfiguration;
import org.springframework.data.couchbase.cache.CouchbaseCacheWriter;
import org.springframework.data.couchbase.cache.DefaultCouchbaseCacheWriter;
import org.springframework.util.Assert;

public class CouchbaseCacheManager
extends AbstractTransactionSupportingCacheManager {
    private final CouchbaseCacheWriter cacheWriter;
    private final CouchbaseCacheConfiguration defaultCacheConfig;
    private final Map<String, CouchbaseCacheConfiguration> initialCacheConfiguration;
    private final boolean allowInFlightCacheCreation;

    private CouchbaseCacheManager(CouchbaseCacheWriter cacheWriter, CouchbaseCacheConfiguration defaultCacheConfiguration, Map<String, CouchbaseCacheConfiguration> initialCacheConfiguration, boolean allowInFlightCacheCreation) {
        Assert.notNull((Object)cacheWriter, (String)"CacheWriter must not be null!");
        Assert.notNull((Object)defaultCacheConfiguration, (String)"DefaultCacheConfiguration must not be null!");
        this.cacheWriter = cacheWriter;
        this.defaultCacheConfig = defaultCacheConfiguration;
        this.initialCacheConfiguration = initialCacheConfiguration;
        this.allowInFlightCacheCreation = allowInFlightCacheCreation;
    }

    public static CouchbaseCacheManager create(CouchbaseClientFactory clientFactory) {
        Assert.notNull((Object)clientFactory, (String)"ConnectionFactory must not be null!");
        return new CouchbaseCacheManager(new DefaultCouchbaseCacheWriter(clientFactory), CouchbaseCacheConfiguration.defaultCacheConfig(), new LinkedHashMap<String, CouchbaseCacheConfiguration>(), true);
    }

    public static CouchbaseCacheManagerBuilder builder(CouchbaseClientFactory clientFactory) {
        Assert.notNull((Object)clientFactory, (String)"ConnectionFactory must not be null!");
        return CouchbaseCacheManagerBuilder.fromConnectionFactory(clientFactory);
    }

    public static CouchbaseCacheManagerBuilder builder(CouchbaseCacheWriter cacheWriter) {
        Assert.notNull((Object)cacheWriter, (String)"CacheWriter must not be null!");
        return CouchbaseCacheManagerBuilder.fromCacheWriter(cacheWriter);
    }

    protected Collection<? extends Cache> loadCaches() {
        LinkedList<CouchbaseCache> caches = new LinkedList<CouchbaseCache>();
        for (Map.Entry<String, CouchbaseCacheConfiguration> entry : this.initialCacheConfiguration.entrySet()) {
            caches.add(this.createCouchbaseCache(entry.getKey(), entry.getValue()));
        }
        return caches;
    }

    protected CouchbaseCache getMissingCache(String name) {
        return this.allowInFlightCacheCreation ? this.createCouchbaseCache(name, this.defaultCacheConfig) : null;
    }

    protected CouchbaseCache createCouchbaseCache(String name, @Nullable CouchbaseCacheConfiguration cacheConfig) {
        return new CouchbaseCache(name, this.cacheWriter, cacheConfig != null ? cacheConfig : this.defaultCacheConfig);
    }

    public static class CouchbaseCacheManagerBuilder {
        private final CouchbaseCacheWriter cacheWriter;
        private final Map<String, CouchbaseCacheConfiguration> initialCaches = new LinkedHashMap<String, CouchbaseCacheConfiguration>();
        boolean allowInFlightCacheCreation = true;
        private CouchbaseCacheConfiguration defaultCacheConfiguration = CouchbaseCacheConfiguration.defaultCacheConfig();
        private boolean enableTransactions;

        private CouchbaseCacheManagerBuilder(CouchbaseCacheWriter cacheWriter) {
            this.cacheWriter = cacheWriter;
        }

        public static CouchbaseCacheManagerBuilder fromConnectionFactory(CouchbaseClientFactory clientFactory) {
            Assert.notNull((Object)clientFactory, (String)"ConnectionFactory must not be null!");
            return CouchbaseCacheManager.builder(new DefaultCouchbaseCacheWriter(clientFactory));
        }

        public static CouchbaseCacheManagerBuilder fromCacheWriter(CouchbaseCacheWriter cacheWriter) {
            Assert.notNull((Object)cacheWriter, (String)"CacheWriter must not be null!");
            return new CouchbaseCacheManagerBuilder(cacheWriter);
        }

        public CouchbaseCacheManagerBuilder cacheDefaults(CouchbaseCacheConfiguration defaultCacheConfiguration) {
            Assert.notNull((Object)defaultCacheConfiguration, (String)"DefaultCacheConfiguration must not be null!");
            this.defaultCacheConfiguration = defaultCacheConfiguration;
            return this;
        }

        public CouchbaseCacheManagerBuilder transactionAware() {
            this.enableTransactions = true;
            return this;
        }

        public CouchbaseCacheManagerBuilder initialCacheNames(Set<String> cacheNames) {
            Assert.notNull(cacheNames, (String)"CacheNames must not be null!");
            cacheNames.forEach(it -> this.withCacheConfiguration((String)it, this.defaultCacheConfiguration));
            return this;
        }

        public CouchbaseCacheManagerBuilder withInitialCacheConfigurations(Map<String, CouchbaseCacheConfiguration> cacheConfigurations) {
            Assert.notNull(cacheConfigurations, (String)"CacheConfigurations must not be null!");
            cacheConfigurations.forEach((cacheName, configuration) -> Assert.notNull((Object)configuration, (String)String.format("CouchbaseCacheConfiguration for cache %s must not be null!", cacheName)));
            this.initialCaches.putAll(cacheConfigurations);
            return this;
        }

        public CouchbaseCacheManagerBuilder withCacheConfiguration(String cacheName, CouchbaseCacheConfiguration cacheConfiguration) {
            Assert.notNull((Object)cacheName, (String)"CacheName must not be null!");
            Assert.notNull((Object)cacheConfiguration, (String)"CacheConfiguration must not be null!");
            this.initialCaches.put(cacheName, cacheConfiguration);
            return this;
        }

        public CouchbaseCacheManagerBuilder disableCreateOnMissingCache() {
            this.allowInFlightCacheCreation = false;
            return this;
        }

        public Set<String> getConfiguredCaches() {
            return Collections.unmodifiableSet(this.initialCaches.keySet());
        }

        public Optional<CouchbaseCacheConfiguration> getCacheConfigurationFor(String cacheName) {
            return Optional.ofNullable(this.initialCaches.get(cacheName));
        }

        public CouchbaseCacheManager build() {
            CouchbaseCacheManager cm = new CouchbaseCacheManager(this.cacheWriter, this.defaultCacheConfiguration, this.initialCaches, this.allowInFlightCacheCreation);
            cm.setTransactionAware(this.enableTransactions);
            return cm;
        }
    }
}

