/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.query;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class Meta {
    private final Map<MetaKey, Object> values = new LinkedHashMap<MetaKey, Object>(2);

    public Meta() {
    }

    Meta(Meta source) {
        this.values.putAll(source.values);
    }

    public boolean hasValues() {
        return !this.values.isEmpty();
    }

    public Iterable<Map.Entry<MetaKey, Object>> values() {
        return Collections.unmodifiableSet(this.values.entrySet());
    }

    public void setValue(String key, @Nullable Object value) {
        Assert.hasText((String)key, (String)"Meta key must not be 'null' or blank.");
        if (value == null || value instanceof String && !StringUtils.hasText((String)((String)value))) {
            this.values.remove((Object)MetaKey.valueOf(key));
        }
        this.values.put(MetaKey.valueOf(key), value);
    }

    public void setValue(MetaKey key, @Nullable Object value) {
        if (value == null || value instanceof String && !StringUtils.hasText((String)((String)value))) {
            this.values.remove((Object)key);
        }
        this.values.put(key, value);
    }

    public void set(MetaKey key, @Nullable Object value) {
        if (value == null || value instanceof String && !StringUtils.hasText((String)((String)value))) {
            this.values.remove((Object)key);
        }
        this.values.put(key, value);
    }

    public <T> @Nullable T getValue(String key) {
        return (T)this.values.get((Object)MetaKey.valueOf(key));
    }

    public <T> T get(MetaKey key) {
        return (T)this.values.get((Object)key);
    }

    public <T> T getValue(String key, T defaultValue) {
        T value = this.getValue(key);
        return value != null ? value : defaultValue;
    }

    public int hashCode() {
        int hash = ObjectUtils.nullSafeHashCode(this.values);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Meta)) {
            return false;
        }
        Meta other = (Meta)obj;
        return ObjectUtils.nullSafeEquals(this.values, other.values);
    }

    public static enum MetaKey {
        SCAN_CONSISTENCY("scan_consistency"),
        SCOPE("scope"),
        COLLECTION("collection"),
        EXPIRY("expiry"),
        EXPIRY_UNIT("expiry_unit"),
        EXPIRY_EXPRESSION("expiry_expression"),
        TIMEOUT("timeout"),
        RETRY_STRATEGY("retry_strategy");

        private String key;

        private MetaKey(String key) {
            this.key = key;
        }
    }
}

