/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import java.util.Map;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.core.query.QueryCriteriaDefinition;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class BasicQuery
extends Query {
    Map<String, String> projectionFields;

    public BasicQuery(Query query, Map<String, String> projectionFields) {
        super(query);
        this.projectionFields = projectionFields;
    }

    public BasicQuery(QueryCriteriaDefinition criteria, Map<String, String> projectionFields) {
        this.addCriteria(criteria);
        this.projectionFields = projectionFields;
    }

    public void setSort(Sort sort) {
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        this.with(sort);
    }

    public boolean isSorted() {
        return this.sort != null && this.sort != Sort.unsorted();
    }

    public void setProjectionFields(Map<String, String> projectionFields) {
        Assert.notNull(projectionFields, (String)"Field document must not be null");
        this.projectionFields = projectionFields;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicQuery)) {
            return false;
        }
        BasicQuery that = (BasicQuery)o;
        return this.querySettingsEquals(that) && ObjectUtils.nullSafeEquals(this.projectionFields, that.projectionFields) && ObjectUtils.nullSafeEquals((Object)this.sort, (Object)that.sort);
    }

    private boolean querySettingsEquals(BasicQuery that) {
        return super.equals(that);
    }

    @Override
    public boolean isReadonly() {
        return true;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.getCriteriaList());
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.projectionFields);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.sort);
        return result;
    }
}

