/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.auditing;

import java.lang.annotation.Annotation;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.data.auditing.ReactiveIsNewAwareAuditingHandler;
import org.springframework.data.auditing.config.AuditingBeanDefinitionRegistrarSupport;
import org.springframework.data.auditing.config.AuditingConfiguration;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.couchbase.core.mapping.event.ReactiveAuditingEntityCallback;
import org.springframework.data.couchbase.core.mapping.event.ReactiveAuditingEventListener;
import org.springframework.data.couchbase.repository.auditing.EnableReactiveCouchbaseAuditing;
import org.springframework.data.couchbase.repository.auditing.PersistentEntitiesFactoryBean;
import org.springframework.util.Assert;

class ReactiveCouchbaseAuditingRegistrar
extends AuditingBeanDefinitionRegistrarSupport {
    ReactiveCouchbaseAuditingRegistrar() {
    }

    protected Class<? extends Annotation> getAnnotation() {
        return EnableReactiveCouchbaseAuditing.class;
    }

    protected String getAuditingHandlerBeanName() {
        return "reactiveCouchbaseAuditingHandler";
    }

    protected BeanDefinitionBuilder getAuditHandlerBeanDefinitionBuilder(AuditingConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"AuditingConfiguration must not be null!");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ReactiveIsNewAwareAuditingHandler.class);
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition(PersistentEntitiesFactoryBean.class);
        definition.setAutowireMode(3);
        builder.addConstructorArgValue((Object)definition.getBeanDefinition());
        return this.configureDefaultAuditHandlerAttributes(configuration, builder);
    }

    protected void registerAuditListenerBeanDefinition(BeanDefinition auditingHandlerDefinition, BeanDefinitionRegistry registry) {
        Assert.notNull((Object)auditingHandlerDefinition, (String)"BeanDefinition must not be null!");
        Assert.notNull((Object)registry, (String)"BeanDefinitionRegistry must not be null!");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ReactiveAuditingEntityCallback.class);
        builder.addConstructorArgValue((Object)ParsingUtils.getObjectFactoryBeanDefinition((String)this.getAuditingHandlerBeanName(), (Object)registry));
        builder.getRawBeanDefinition().setSource(auditingHandlerDefinition.getSource());
        this.registerInfrastructureBeanWithId(builder.getBeanDefinition(), ReactiveAuditingEntityCallback.class.getName(), registry);
        BeanDefinitionBuilder builder2 = BeanDefinitionBuilder.rootBeanDefinition(ReactiveAuditingEventListener.class);
        builder2.addConstructorArgValue((Object)ParsingUtils.getObjectFactoryBeanDefinition((String)this.getAuditingHandlerBeanName(), (Object)registry));
        builder.getRawBeanDefinition().setSource(auditingHandlerDefinition.getSource());
        this.registerInfrastructureBeanWithId(builder2.getBeanDefinition(), ReactiveAuditingEventListener.class.getName(), registry);
    }
}

