/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert.join;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.query.FetchType;
import org.springframework.data.couchbase.core.query.HashSide;
import org.springframework.data.couchbase.core.query.N1qlJoin;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class N1qlJoinResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(N1qlJoinResolver.class);

    public static String buildQuery(CouchbaseTemplate template, N1qlJoinResolverParameters parameters) {
        String joinType = "JOIN";
        String selectEntity = "SELECT META(rks).id AS __id, META(rks).cas AS __cas, (rks).* ";
        StringBuilder useLKSBuilder = new StringBuilder();
        if (parameters.getJoinDefinition().index().length() > 0) {
            useLKSBuilder.append("INDEX(" + parameters.getJoinDefinition().index() + ")");
        }
        String useLKS = useLKSBuilder.length() > 0 ? "USE " + useLKSBuilder.toString() + " " : "";
        String from = "FROM `" + template.getBucketName() + "` lks " + useLKS + joinType + " `" + template.getBucketName() + "` rks";
        String onLks = "lks." + template.getConverter().getTypeKey() + " = \"" + parameters.getEntityTypeInfo().getType().getName() + "\"";
        String onRks = "rks." + template.getConverter().getTypeKey() + " = \"" + parameters.getAssociatedEntityTypeInfo().getType().getName() + "\"";
        StringBuilder useRKSBuilder = new StringBuilder();
        if (parameters.getJoinDefinition().rightIndex().length() > 0) {
            useRKSBuilder.append("INDEX(" + parameters.getJoinDefinition().rightIndex() + ")");
        }
        if (!parameters.getJoinDefinition().hashside().equals((Object)HashSide.NONE)) {
            if (useRKSBuilder.length() > 0) {
                useRKSBuilder.append(" ");
            }
            useRKSBuilder.append("HASH(" + parameters.getJoinDefinition().hashside().getValue() + ")");
        }
        if (parameters.getJoinDefinition().keys().length > 0) {
            if (useRKSBuilder.length() > 0) {
                useRKSBuilder.append(" ");
            }
            useRKSBuilder.append("KEYS [");
            String[] keys = parameters.getJoinDefinition().keys();
            for (int i = 0; i < keys.length; ++i) {
                if (i != 0) {
                    useRKSBuilder.append(",");
                }
                useRKSBuilder.append("\"" + keys[i] + "\"");
            }
            useRKSBuilder.append("]");
        }
        String on = "ON " + parameters.getJoinDefinition().on().concat(" AND " + onLks).concat(" AND " + onRks);
        String where = "WHERE META(lks).id=\"" + parameters.getLksId() + "\"";
        where = where + (parameters.getJoinDefinition().where().length() > 0 ? " AND " + parameters.getJoinDefinition().where() : "");
        StringBuilder statementSb = new StringBuilder();
        statementSb.append(selectEntity);
        statementSb.append(" " + from);
        statementSb.append(useRKSBuilder.length() > 0 ? " USE " + useRKSBuilder.toString() : "");
        statementSb.append(" " + on);
        statementSb.append(" " + where);
        return statementSb.toString();
    }

    public static <R> List<R> doResolve(CouchbaseTemplate template, N1qlJoinResolverParameters parameters, Class<R> associatedEntityClass) {
        throw new UnsupportedOperationException();
    }

    public static boolean isLazyJoin(N1qlJoin joinDefinition) {
        return joinDefinition.fetchType().equals((Object)FetchType.LAZY);
    }

    public static class N1qlJoinResolverParameters {
        private N1qlJoin joinDefinition;
        private String lksId;
        private TypeInformation<?> entityTypeInfo;
        private TypeInformation<?> associatedEntityTypeInfo;

        public N1qlJoinResolverParameters(N1qlJoin joinDefinition, String lksId, TypeInformation<?> entityTypeInfo, TypeInformation<?> associatedEntityTypeInfo) {
            Assert.notNull((Object)joinDefinition, (String)"The join definition is required");
            Assert.notNull(entityTypeInfo, (String)"The entity type information is required");
            Assert.notNull(associatedEntityTypeInfo, (String)"The associated entity type information is required");
            this.joinDefinition = joinDefinition;
            this.lksId = lksId;
            this.entityTypeInfo = entityTypeInfo;
            this.associatedEntityTypeInfo = associatedEntityTypeInfo;
        }

        public N1qlJoin getJoinDefinition() {
            return this.joinDefinition;
        }

        public String getLksId() {
            return this.lksId;
        }

        public TypeInformation getEntityTypeInfo() {
            return this.entityTypeInfo;
        }

        public TypeInformation getAssociatedEntityTypeInfo() {
            return this.associatedEntityTypeInfo;
        }
    }

    public static class N1qlJoinProxy
    implements InvocationHandler {
        private final CouchbaseTemplate template;
        private final N1qlJoinResolverParameters params;
        private List<?> resolved = null;

        public N1qlJoinProxy(CouchbaseTemplate template, N1qlJoinResolverParameters params) {
            this.template = template;
            this.params = params;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.resolved == null) {
                this.resolved = N1qlJoinResolver.doResolve(this.template, this.params, this.params.associatedEntityTypeInfo.getType());
            }
            return method.invoke(this.resolved, args);
        }
    }
}

