/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.view.ViewQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.query.View;
import org.springframework.data.couchbase.repository.query.ConvertingIterator;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class ViewQueryCreator
extends AbstractQueryCreator<DerivedViewQuery, ViewQuery> {
    private ViewQuery query;
    private final View viewAnnotation;
    private final PartTree tree;
    private final int treeCount;
    private final CouchbaseConverter converter;

    public ViewQueryCreator(PartTree tree, ParameterAccessor parameters, View viewAnnotation, ViewQuery query, CouchbaseConverter converter) {
        super(tree, parameters);
        this.query = query;
        this.viewAnnotation = viewAnnotation;
        this.tree = tree;
        this.converter = converter;
        int i = 0;
        HashSet<String> properties = new HashSet<String>();
        for (PartTree.OrPart parts : tree) {
            for (Part part : parts) {
                ++i;
                properties.add(part.getProperty().toDotPath());
            }
        }
        this.treeCount = i;
        if (properties.size() > 1) {
            throw new IllegalArgumentException("View-based queries do not support compound keys");
        }
    }

    protected ViewQuery create(Part part, Iterator<Object> objectIterator) {
        ConvertingIterator iterator = new ConvertingIterator(objectIterator, this.converter);
        switch (part.getType()) {
            case GREATER_THAN_EQUAL: {
                this.startKey(iterator);
                break;
            }
            case LESS_THAN_EQUAL: {
                this.query.inclusiveEnd(true);
            }
            case BEFORE: 
            case LESS_THAN: {
                this.endKey(iterator);
                break;
            }
            case BETWEEN: {
                this.startKey(iterator);
                this.endKey(iterator);
                break;
            }
            case STARTING_WITH: {
                String nameStart = this.nextString(iterator);
                this.query.startKey(nameStart).endKey(nameStart + "\uefff");
                this.query.inclusiveEnd(false);
                break;
            }
            case SIMPLE_PROPERTY: {
                this.key(iterator);
                break;
            }
            case IN: {
                this.query.keys(this.in(iterator));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported keyword in View query derivation: " + part.toString());
            }
        }
        return this.query;
    }

    private void startKey(Iterator<Object> iterator) {
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("Not enough parameters for startKey");
        }
        Object next = iterator.next();
        if (next instanceof String) {
            this.query.startKey((String)next);
        } else if (next instanceof Boolean) {
            this.query.startKey(((Boolean)next).booleanValue());
        } else if (next instanceof Double) {
            this.query.startKey(((Double)next).doubleValue());
        } else if (next instanceof Integer) {
            this.query.startKey(((Integer)next).intValue());
        } else if (next instanceof Long) {
            this.query.startKey(((Long)next).longValue());
        } else if (next instanceof Collection) {
            ArrayList arrayContent = new ArrayList((Collection)next);
            this.query.startKey(JsonArray.from(arrayContent));
        } else if (next.getClass().isArray()) {
            List<Object> arrayContent = Arrays.asList((Object[])next);
            this.query.startKey(JsonArray.from(arrayContent));
        } else if (next instanceof JsonArray) {
            this.query.startKey((JsonArray)next);
        } else if (next instanceof JsonObject) {
            this.query.startKey((JsonObject)next);
        } else {
            throw new IllegalArgumentException("Unsupported parameter type for startKey: " + next.getClass());
        }
    }

    private void endKey(Iterator<Object> iterator) {
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("Not enough parameters for endKey");
        }
        Object next = iterator.next();
        if (next instanceof String) {
            this.query.endKey((String)next);
        } else if (next instanceof Boolean) {
            this.query.endKey(((Boolean)next).booleanValue());
        } else if (next instanceof Double) {
            this.query.endKey(((Double)next).doubleValue());
        } else if (next instanceof Integer) {
            this.query.endKey(((Integer)next).intValue());
        } else if (next instanceof Long) {
            this.query.endKey(((Long)next).longValue());
        } else if (next instanceof Collection) {
            ArrayList arrayContent = new ArrayList((Collection)next);
            this.query.endKey(JsonArray.from(arrayContent));
        } else if (next.getClass().isArray()) {
            List<Object> arrayContent = Arrays.asList((Object[])next);
            this.query.endKey(JsonArray.from(arrayContent));
        } else if (next instanceof JsonArray) {
            this.query.endKey((JsonArray)next);
        } else if (next instanceof JsonObject) {
            this.query.endKey((JsonObject)next);
        } else {
            throw new IllegalArgumentException("Unsupported parameter type for endKey: " + next.getClass());
        }
    }

    private void key(Iterator<Object> iterator) {
        if (!iterator.hasNext() && this.treeCount > 1) {
            throw new IllegalArgumentException("Not enough parameters for key");
        }
        if (!iterator.hasNext()) {
            return;
        }
        Object next = iterator.next();
        if (next instanceof String) {
            this.query.key((String)next);
        } else if (next instanceof Boolean) {
            this.query.key(((Boolean)next).booleanValue());
        } else if (next instanceof Double) {
            this.query.key(((Double)next).doubleValue());
        } else if (next instanceof Integer) {
            this.query.key(((Integer)next).intValue());
        } else if (next instanceof Long) {
            this.query.key(((Long)next).longValue());
        } else if (next instanceof Collection) {
            ArrayList arrayContent = new ArrayList((Collection)next);
            this.query.key(JsonArray.from(arrayContent));
        } else if (next.getClass().isArray()) {
            List<Object> arrayContent = Arrays.asList((Object[])next);
            this.query.key(JsonArray.from(arrayContent));
        } else if (next instanceof JsonArray) {
            this.query.key((JsonArray)next);
        } else if (next instanceof JsonObject) {
            this.query.key((JsonObject)next);
        } else {
            throw new IllegalArgumentException("Unsupported parameter type for key: " + next.getClass());
        }
    }

    private String nextString(Iterator<Object> iterator) {
        if (!iterator.hasNext()) {
            throw new IllegalStateException("Not enough parameters");
        }
        Object next = iterator.next();
        if (!(next instanceof String)) {
            throw new IllegalArgumentException("Expected String, got " + next.getClass().getName());
        }
        return (String)next;
    }

    private JsonArray in(Iterator<Object> iterator) {
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("Not enough parameters for in");
        }
        Object next = iterator.next();
        List<Object> values = next instanceof Collection ? new ArrayList((Collection)next) : (next.getClass().isArray() ? Arrays.asList((Object[])next) : Collections.singletonList(next));
        return JsonArray.from(values);
    }

    protected ViewQuery and(Part part, ViewQuery base, Iterator<Object> iterator) {
        return this.create(part, iterator);
    }

    protected ViewQuery or(ViewQuery base, ViewQuery criteria) {
        throw new UnsupportedOperationException("Or is not supported for View-based queries");
    }

    protected DerivedViewQuery complete(ViewQuery criteria, Sort sort) {
        boolean isExplicitReduce;
        boolean descending = false;
        if (sort.isSorted()) {
            int sortCount = 0;
            Iterator it = sort.iterator();
            while (it.hasNext()) {
                ++sortCount;
                if (((Sort.Order)it.next()).isAscending()) continue;
                descending = true;
            }
            if (sortCount > 1) {
                throw new IllegalArgumentException("Detected " + sortCount + " sort instructions, maximum one supported");
            }
            this.query.descending(descending);
        }
        if (this.tree.isLimiting()) {
            this.query.limit(this.tree.getMaxResults().intValue());
        }
        boolean isCount = this.tree.isCountProjection() == Boolean.TRUE.booleanValue();
        boolean bl = isExplicitReduce = this.viewAnnotation != null && this.viewAnnotation.reduce();
        if (isCount || isExplicitReduce) {
            this.query.reduce();
        }
        return new DerivedViewQuery(this.query, this.tree.isLimiting(), isCount || isExplicitReduce);
    }

    protected static class DerivedViewQuery {
        public final ViewQuery builtQuery;
        public final boolean isLimited;
        public final boolean isReduce;

        public DerivedViewQuery(ViewQuery builtQuery, boolean isLimited, boolean isReduce) {
            this.builtQuery = builtQuery;
            this.isLimited = isLimited;
            this.isReduce = isReduce;
        }
    }
}

