/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.query;

import com.couchbase.client.java.query.consistency.ScanConsistency;
import com.couchbase.client.java.view.Stale;

public enum Consistency {
    READ_YOUR_OWN_WRITES(Stale.FALSE, ScanConsistency.STATEMENT_PLUS),
    STRONGLY_CONSISTENT(Stale.FALSE, ScanConsistency.REQUEST_PLUS),
    UPDATE_AFTER(Stale.UPDATE_AFTER, ScanConsistency.NOT_BOUNDED),
    EVENTUALLY_CONSISTENT(Stale.TRUE, ScanConsistency.NOT_BOUNDED);

    public static final Consistency DEFAULT_CONSISTENCY;
    private final Stale viewConsistency;
    private final ScanConsistency n1qlConsistency;

    private Consistency(Stale viewConsistency, ScanConsistency n1qlConsistency) {
        this.viewConsistency = viewConsistency;
        this.n1qlConsistency = n1qlConsistency;
    }

    public Stale viewConsistency() {
        return this.viewConsistency;
    }

    public ScanConsistency n1qlConsistency() {
        return this.n1qlConsistency;
    }

    static {
        DEFAULT_CONSISTENCY = READ_YOUR_OWN_WRITES;
    }
}

