/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.config;

import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.cluster.ClusterInfo;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.couchbase.core.CouchbaseExceptionTranslator;

public class CouchbaseClusterInfoFactoryBean
extends AbstractFactoryBean<ClusterInfo>
implements PersistenceExceptionTranslator {
    private final Cluster cluster;
    private final String login;
    private final String password;
    private final PersistenceExceptionTranslator exceptionTranslator = new CouchbaseExceptionTranslator();

    public CouchbaseClusterInfoFactoryBean(Cluster cluster, String login, String password) {
        this.cluster = cluster;
        this.login = login;
        this.password = password;
    }

    public Class<?> getObjectType() {
        return ClusterInfo.class;
    }

    protected ClusterInfo createInstance() throws Exception {
        return this.cluster.clusterManager(this.login, this.password).info();
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.exceptionTranslator.translateExceptionIfPossible(ex);
    }
}

