/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.projection;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.util.ReflectionUtils;

public class DefaultMethodInvokingMethodInterceptor
implements MethodInterceptor {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private final Map<Method, MethodHandle> methodHandleCache = new ConcurrentHashMap<Method, MethodHandle>();

    public static boolean hasDefaultMethods(Class<?> interfaceClass) {
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        ReflectionUtils.doWithMethods(interfaceClass, method -> atomicBoolean.set(true), Method::isDefault);
        return atomicBoolean.get();
    }

    public @Nullable Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (!method.isDefault()) {
            return invocation.proceed();
        }
        Object[] arguments = invocation.getArguments();
        Object proxy = ((ProxyMethodInvocation)invocation).getProxy();
        return this.getMethodHandle(method).bindTo(proxy).invokeWithArguments(arguments);
    }

    private MethodHandle getMethodHandle(Method method) throws Exception {
        MethodHandle handle = this.methodHandleCache.get(method);
        if (handle == null) {
            handle = DefaultMethodInvokingMethodInterceptor.lookup(method);
            this.methodHandleCache.put(method, handle);
        }
        return handle;
    }

    private static MethodHandle lookup(Method method) throws ReflectiveOperationException {
        MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(method.getDeclaringClass(), LOOKUP);
        MethodType methodType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
        Class<?> declaringClass = method.getDeclaringClass();
        return Modifier.isStatic(method.getModifiers()) ? lookup.findStatic(declaringClass, method.getName(), methodType) : lookup.findSpecial(declaringClass, method.getName(), methodType, declaringClass);
    }
}

