/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web.config;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.web.config.HateoasAwareSpringDataWebConfiguration;
import org.springframework.data.web.config.ProjectingArgumentResolverRegistrar;
import org.springframework.data.web.config.QuerydslWebConfiguration;
import org.springframework.data.web.config.SpringDataJackson3Modules;
import org.springframework.data.web.config.SpringDataJacksonModules;
import org.springframework.data.web.config.SpringDataWebConfiguration;
import org.springframework.data.web.config.SpringDataWebSettings;
import org.springframework.util.ClassUtils;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.ANNOTATION_TYPE})
@Inherited
@Import(value={SpringDataWebConfigurationImportSelector.class, QuerydslActivator.class, SpringDataWebSettingsRegistrar.class})
public @interface EnableSpringDataWebSupport {
    public PageSerializationMode pageSerializationMode() default PageSerializationMode.DIRECT;

    public static class SpringDataWebSettingsRegistrar
    implements ImportBeanDefinitionRegistrar {
        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry, BeanNameGenerator importBeanNameGenerator) {
            Map attributes = importingClassMetadata.getAnnotationAttributes(EnableSpringDataWebSupport.class.getName());
            if (attributes == null) {
                return;
            }
            Object pageSerializationMode = attributes.get("pageSerializationMode");
            if (pageSerializationMode == PageSerializationMode.DIRECT) {
                return;
            }
            AbstractBeanDefinition definition = BeanDefinitionBuilder.rootBeanDefinition(SpringDataWebSettings.class).addConstructorArgValue(pageSerializationMode).getBeanDefinition();
            String beanName = importBeanNameGenerator.generateBeanName((BeanDefinition)definition, registry);
            registry.registerBeanDefinition(beanName, (BeanDefinition)definition);
        }
    }

    public static class QuerydslActivator
    implements ImportSelector {
        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            String[] stringArray;
            if (QuerydslUtils.QUERY_DSL_PRESENT) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = QuerydslWebConfiguration.class.getName();
            } else {
                stringArray = new String[]{};
            }
            return stringArray;
        }
    }

    public static class SpringDataWebConfigurationImportSelector
    implements ImportSelector,
    ResourceLoaderAware {
        private Optional<ClassLoader> resourceLoader = Optional.empty();

        public void setResourceLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = Optional.of(resourceLoader).map(ResourceLoader::getClassLoader);
        }

        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            ArrayList<String> imports = new ArrayList<String>();
            imports.add(ProjectingArgumentResolverRegistrar.class.getName());
            imports.add(this.resourceLoader.filter(it -> ClassUtils.isPresent((String)"org.springframework.hateoas.Link", (ClassLoader)it)).map(it -> HateoasAwareSpringDataWebConfiguration.class.getName()).orElseGet(() -> SpringDataWebConfiguration.class.getName()));
            this.resourceLoader.filter(it -> ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)it)).map(it -> SpringFactoriesLoader.loadFactoryNames(SpringDataJacksonModules.class, (ClassLoader)it)).ifPresent(imports::addAll);
            this.resourceLoader.filter(it -> ClassUtils.isPresent((String)"tools.jackson.databind.ObjectMapper", (ClassLoader)it)).map(it -> SpringFactoriesLoader.loadFactoryNames(SpringDataJackson3Modules.class, (ClassLoader)it)).ifPresent(imports::addAll);
            return imports.toArray(new String[imports.size()]);
        }
    }

    public static enum PageSerializationMode {
        DIRECT,
        VIA_DTO;

    }
}

