/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.ResolvableType;
import org.springframework.data.util.TypeDiscoverer;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentLruCache;

class ClassTypeInformation<S>
extends TypeDiscoverer<S> {
    private static final ConcurrentLruCache<ResolvableType, ClassTypeInformation<?>> cache = new ConcurrentLruCache(128, ClassTypeInformation::new);
    private static final ConcurrentLruCache<Class<?>, ResolvableType> resolvableTypeCache = new ConcurrentLruCache(128, ResolvableType::forClass);
    private final Class<S> type;

    ClassTypeInformation(Class<?> type) {
        this(ResolvableType.forType(type));
    }

    ClassTypeInformation(ResolvableType type) {
        super(type);
        this.type = type.resolve(Object.class);
    }

    public static <S> ClassTypeInformation<S> from(Class<S> type) {
        if (type == Object.class) {
            return (ClassTypeInformation)TypeInformation.OBJECT;
        }
        if (type == List.class) {
            return (ClassTypeInformation)TypeInformation.LIST;
        }
        if (type == Set.class) {
            return (ClassTypeInformation)TypeInformation.SET;
        }
        if (type == Map.class) {
            return (ClassTypeInformation)TypeInformation.MAP;
        }
        return ClassTypeInformation.from((ResolvableType)resolvableTypeCache.get(type));
    }

    static <S> ClassTypeInformation<S> from(ResolvableType type) {
        Assert.notNull((Object)type, (String)"Type must not be null");
        if (type.getType() == Object.class) {
            return (ClassTypeInformation)TypeInformation.OBJECT;
        }
        if (type.getType() == List.class) {
            return (ClassTypeInformation)TypeInformation.LIST;
        }
        if (type.getType() == Set.class) {
            return (ClassTypeInformation)TypeInformation.SET;
        }
        if (type.getType() == Map.class) {
            return (ClassTypeInformation)TypeInformation.MAP;
        }
        return (ClassTypeInformation)cache.get((Object)type);
    }

    @Override
    public Class<S> getType() {
        return this.type;
    }

    @Override
    public ClassTypeInformation<?> getRawTypeInformation() {
        return this;
    }

    @Override
    public boolean isAssignableFrom(TypeInformation<?> target) {
        return this.getType().isAssignableFrom(target.getType());
    }

    @Override
    public TypeInformation<? extends S> specialize(TypeInformation<?> type) {
        return type;
    }

    @Override
    public String toString() {
        return this.type.getName();
    }
}

