/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.data.util.TypeInformation;

record ResolvableGenerics(Method method, Class<?> implClass, Set<Type> resolvableTypeVariables, Set<Type> unwantedMethodVariables) {
    public static ResolvableGenerics of(Method method, Class<?> implClass) {
        return new ResolvableGenerics(method, implClass, ResolvableGenerics.getResolvableTypeVariables(method), ResolvableGenerics.getUnwantedMethodVariables(method));
    }

    public boolean isFullyResolvableParameter(Parameter parameter) {
        MethodParameter methodParameter = MethodParameter.forParameter((Parameter)parameter).withContainingClass(this.implClass);
        ResolvableType resolvableType = ResolvableType.forMethodParameter((MethodParameter)methodParameter);
        return ResolvableGenerics.testGenericType(resolvableType, o -> {
            if (o instanceof WildcardType) {
                WildcardType wt = (WildcardType)o;
                return !this.isResolvable(wt.getLowerBounds()) || !this.isResolvable(wt.getUpperBounds());
            }
            if (o instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)o;
                return this.isResolvable(pt.getActualTypeArguments());
            }
            return this.unwantedMethodVariables.contains(o);
        });
    }

    private static Set<Type> getResolvableTypeVariables(Method method) {
        HashSet<Type> simpleTypeVariables = new HashSet<Type>();
        for (TypeVariable<Method> typeParameter : method.getTypeParameters()) {
            if (!ResolvableGenerics.isClassBounded(typeParameter.getBounds())) continue;
            simpleTypeVariables.add(typeParameter);
        }
        return simpleTypeVariables;
    }

    private static Set<Type> getUnwantedMethodVariables(Method method) {
        HashSet<Type> unwanted = new HashSet<Type>();
        for (TypeVariable<Method> typeParameter : method.getTypeParameters()) {
            if (ResolvableGenerics.isClassBounded(typeParameter.getBounds())) continue;
            unwanted.add(typeParameter);
        }
        return unwanted;
    }

    public boolean hasUnresolvableGenerics() {
        ResolvableType resolvableType = ResolvableType.forMethodReturnType((Method)this.method, this.implClass);
        if (this.isUnresolvable(resolvableType)) {
            return true;
        }
        for (int i = 0; i < this.method.getParameterCount(); ++i) {
            if (!this.isUnresolvable(ResolvableType.forMethodParameter((Method)this.method, (int)i, this.implClass))) continue;
            return true;
        }
        return false;
    }

    private boolean isUnresolvable(TypeInformation<?> typeInformation) {
        return this.isUnresolvable(typeInformation.toResolvableType());
    }

    private boolean isUnresolvable(ResolvableType resolvableType) {
        if (this.isResolvable(resolvableType)) {
            return false;
        }
        if (this.isUnwanted(resolvableType)) {
            return true;
        }
        if (resolvableType.isAssignableFrom(Class.class)) {
            return this.isUnresolvable(resolvableType.getGeneric(new int[]{0}));
        }
        TypeInformation<?> typeInformation = TypeInformation.of(resolvableType);
        if (typeInformation.isMap() || typeInformation.isCollectionLike()) {
            for (ResolvableType type : resolvableType.getGenerics()) {
                if (!this.isUnresolvable(type)) continue;
                return true;
            }
            return false;
        }
        if (typeInformation.getActualType() != null && typeInformation.getActualType() != typeInformation) {
            return this.isUnresolvable(typeInformation.getRequiredActualType());
        }
        return resolvableType.hasUnresolvableGenerics();
    }

    private boolean isResolvable(Type[] types) {
        for (Type type : types) {
            if (this.resolvableTypeVariables.contains(type) || ResolvableGenerics.isClass(type)) continue;
            return false;
        }
        return true;
    }

    private boolean isResolvable(ResolvableType resolvableType) {
        return ResolvableGenerics.testGenericType(resolvableType, it -> {
            if (this.resolvableTypeVariables.contains(it)) {
                return true;
            }
            if (it instanceof WildcardType) {
                WildcardType wt = (WildcardType)it;
                return ResolvableGenerics.isClassBounded(wt.getLowerBounds()) && ResolvableGenerics.isClassBounded(wt.getUpperBounds());
            }
            return false;
        });
    }

    private boolean isUnwanted(ResolvableType resolvableType) {
        return ResolvableGenerics.testGenericType(resolvableType, o -> {
            if (o instanceof WildcardType) {
                WildcardType wt = (WildcardType)o;
                return !this.isResolvable(wt.getLowerBounds()) || !this.isResolvable(wt.getUpperBounds());
            }
            return this.unwantedMethodVariables.contains(o);
        });
    }

    private static boolean testGenericType(ResolvableType resolvableType, Predicate<Type> predicate) {
        ResolvableType[] generics;
        if (predicate.test(resolvableType.getType())) {
            return true;
        }
        for (ResolvableType generic : generics = resolvableType.getGenerics()) {
            if (!ResolvableGenerics.testGenericType(generic, predicate)) continue;
            return true;
        }
        return false;
    }

    private static boolean isClassBounded(Type[] bounds) {
        for (Type bound : bounds) {
            if (ResolvableGenerics.isClass(bound)) continue;
            return false;
        }
        return true;
    }

    private static boolean isClass(Type type) {
        return type instanceof Class;
    }
}

