/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragments;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragmentsDecorator;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.data.aot.AotContext;
import org.springframework.data.aot.AotTypeConfiguration;
import org.springframework.data.projection.EntityProjectionIntrospector;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.aot.generate.AotRepositoryBeanDefinitionPropertiesDecorator;
import org.springframework.data.repository.aot.generate.RepositoryContributor;
import org.springframework.data.repository.config.AotRepositoryContext;
import org.springframework.data.repository.config.DefaultAotRepositoryContext;
import org.springframework.data.repository.config.RepositoryBeanDefinitionReader;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryRegistrationAotProcessor;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeUtils;
import org.springframework.javapoet.CodeBlock;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class RepositoryRegistrationAotContribution
implements BeanRegistrationAotContribution,
EnvironmentAware {
    private static final Log logger = LogFactory.getLog(RepositoryRegistrationAotContribution.class);
    private static final String KOTLIN_COROUTINE_REPOSITORY_TYPE_NAME = "org.springframework.data.repository.kotlin.CoroutineCrudRepository";
    private final RepositoryRegistrationAotProcessor aotProcessor;
    private final AotRepositoryContext repositoryContext;
    private @Nullable RepositoryContributor repositoryContributor;
    private Lazy<Environment> environment = Lazy.of(StandardEnvironment::new);
    private @Nullable BiFunction<AotRepositoryContext, GenerationContext, @Nullable RepositoryContributor> moduleContribution;

    protected RepositoryRegistrationAotContribution(RepositoryRegistrationAotProcessor processor, AotRepositoryContext context) {
        Assert.notNull((Object)processor, (String)"RepositoryRegistrationAotProcessor must not be null");
        Assert.notNull((Object)context, (String)"AotRepositoryContext must not be null");
        this.aotProcessor = processor;
        this.repositoryContext = context;
    }

    public static @Nullable RepositoryRegistrationAotContribution load(RepositoryRegistrationAotProcessor processor, RegisteredBean repositoryBean) {
        RepositoryConfiguration<?> repositoryMetadata = processor.getRepositoryMetadata(repositoryBean);
        if (repositoryMetadata == null) {
            return null;
        }
        AotRepositoryContext repositoryContext = RepositoryRegistrationAotContribution.buildAotRepositoryContext(processor.getEnvironment(), repositoryBean);
        if (repositoryContext == null) {
            return null;
        }
        return new RepositoryRegistrationAotContribution(processor, repositoryContext);
    }

    @Deprecated(since="4.0", forRemoval=true)
    public @Nullable RepositoryRegistrationAotContribution forBean(RegisteredBean repositoryBean) {
        RepositoryConfiguration<?> repositoryMetadata = this.getRepositoryRegistrationAotProcessor().getRepositoryMetadata(repositoryBean);
        if (repositoryMetadata == null) {
            return null;
        }
        AotRepositoryContext repositoryContext = RepositoryRegistrationAotContribution.buildAotRepositoryContext(this.aotProcessor.getEnvironment(), repositoryBean);
        if (repositoryContext == null) {
            return null;
        }
        return new RepositoryRegistrationAotContribution(this.getRepositoryRegistrationAotProcessor(), repositoryContext);
    }

    protected @Nullable BiFunction<AotRepositoryContext, GenerationContext, @Nullable RepositoryContributor> getModuleContribution() {
        return this.moduleContribution;
    }

    protected AotRepositoryContext getRepositoryContext() {
        return this.repositoryContext;
    }

    protected RepositoryRegistrationAotProcessor getRepositoryRegistrationAotProcessor() {
        return this.aotProcessor;
    }

    public RepositoryInformation getRepositoryInformation() {
        return this.getRepositoryContext().getRepositoryInformation();
    }

    private void logTrace(String message, Object ... arguments) {
        this.getRepositoryRegistrationAotProcessor().logTrace(message, arguments);
    }

    private static @Nullable AotRepositoryContext buildAotRepositoryContext(Environment environment, RegisteredBean bean) {
        RepositoryBeanDefinitionReader reader = new RepositoryBeanDefinitionReader(bean);
        RepositoryConfiguration<?> configuration = reader.getConfiguration();
        RepositoryConfigurationExtensionSupport extension = reader.getConfigurationExtension();
        if (configuration == null || extension == null) {
            logger.warn((Object)"Cannot create AotRepositoryContext for bean [%s]. No RepositoryConfiguration/RepositoryConfigurationExtension. Please make sure to register the repository bean through @Enable\u2026Repositories.".formatted(bean.getBeanName()));
            return null;
        }
        RepositoryInformation repositoryInformation = reader.getRepositoryInformation();
        DefaultAotRepositoryContext repositoryContext = new DefaultAotRepositoryContext(bean, repositoryInformation, extension.getModuleName(), AotContext.from((BeanFactory)bean.getBeanFactory(), environment), (RepositoryConfigurationSource)configuration.getConfigurationSource());
        repositoryContext.setIdentifyingAnnotations(extension.getIdentifyingAnnotations());
        return repositoryContext;
    }

    public RepositoryRegistrationAotContribution withModuleContribution(@Nullable BiFunction<AotRepositoryContext, GenerationContext, @Nullable RepositoryContributor> moduleContribution) {
        this.moduleContribution = moduleContribution;
        return this;
    }

    public void setEnvironment(Environment environment) {
        this.environment = Lazy.of(environment);
    }

    public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
        this.contributeRepositoryInfo(this.repositoryContext, generationContext);
        BiFunction<AotRepositoryContext, GenerationContext, RepositoryContributor> moduleContribution = this.getModuleContribution();
        if (moduleContribution != null && this.repositoryContributor == null) {
            this.repositoryContributor = moduleContribution.apply(this.getRepositoryContext(), generationContext);
            if (this.repositoryContributor != null) {
                this.repositoryContributor.contribute(generationContext);
            }
        }
        this.getRepositoryContext().typeConfigurations().forEach(typeConfiguration -> typeConfiguration.contribute(this.environment.get(), generationContext));
    }

    public BeanRegistrationCodeFragments customizeBeanRegistrationCodeFragments(GenerationContext generationContext, BeanRegistrationCodeFragments codeFragments) {
        return new BeanRegistrationCodeFragmentsDecorator(codeFragments){

            public CodeBlock generateSetBeanDefinitionPropertiesCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode, RootBeanDefinition beanDefinition, Predicate<String> attributeFilter) {
                Supplier<CodeBlock> inheritedProperties = () -> super.generateSetBeanDefinitionPropertiesCode(generationContext, beanRegistrationCode, beanDefinition, attributeFilter);
                if (RepositoryRegistrationAotContribution.this.repositoryContributor == null) {
                    return inheritedProperties.get();
                }
                AotRepositoryBeanDefinitionPropertiesDecorator decorator = new AotRepositoryBeanDefinitionPropertiesDecorator(inheritedProperties, RepositoryRegistrationAotContribution.this.repositoryContributor);
                return decorator.decorate();
            }
        };
    }

    private void contributeRepositoryInfo(AotRepositoryContext repositoryContext, GenerationContext contribution) {
        RepositoryInformation repositoryInformation = this.getRepositoryInformation();
        this.logTrace("Contributing repository information for [%s]", repositoryInformation.getRepositoryInterface());
        repositoryContext.typeConfiguration(repositoryInformation.getRepositoryInterface(), config -> config.forReflectiveAccess(MemberCategory.INVOKE_PUBLIC_METHODS).repositoryProxy());
        repositoryContext.typeConfiguration(repositoryInformation.getRepositoryBaseClass(), config -> config.forReflectiveAccess(MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS));
        repositoryContext.typeConfiguration(repositoryInformation.getDomainType(), config -> config.forDataBinding().forQuerydsl());
        repositoryContext.getUserDomainTypes().forEach(it -> repositoryContext.typeConfiguration((Class<?>)it, AotTypeConfiguration::contributeAccessors));
        this.contributeFragments(contribution);
        if (this.isKotlinCoroutineRepository(repositoryContext, repositoryInformation)) {
            contribution.getRuntimeHints().reflection().registerTypes(this.kotlinRepositoryReflectionTypeReferences(), hint -> {});
        }
        repositoryInformation.getQueryMethods().stream().map(repositoryInformation::getReturnedDomainClass).filter(Class::isInterface).forEach(type -> {
            if (EntityProjectionIntrospector.ProjectionPredicate.typeHierarchy().test((Class<?>)type, repositoryInformation.getDomainType())) {
                repositoryContext.typeConfiguration((Class<?>)type, AotTypeConfiguration::usedAsProjectionInterface);
            }
        });
    }

    private void contributeFragments(GenerationContext contribution) {
        for (RepositoryFragment<?> fragment : this.getRepositoryInformation().getFragments()) {
            Class<?> repositoryFragmentType = fragment.getSignatureContributor();
            Optional<Class<?>> implementation = fragment.getImplementationClass();
            contribution.getRuntimeHints().reflection().registerType(repositoryFragmentType, hint -> {
                hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS});
                if (!repositoryFragmentType.isInterface()) {
                    hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
                }
            });
            implementation.ifPresent(typeToRegister -> contribution.getRuntimeHints().reflection().registerType(typeToRegister, hint -> {
                hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS});
                if (!typeToRegister.isInterface()) {
                    hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
                }
            }));
        }
    }

    private boolean isKotlinCoroutineRepository(AotRepositoryContext repositoryContext, RepositoryInformation repositoryInformation) {
        return repositoryContext.introspectType(KOTLIN_COROUTINE_REPOSITORY_TYPE_NAME).resolveType().filter(it -> ClassUtils.isAssignable((Class)it, repositoryInformation.getRepositoryInterface())).isPresent();
    }

    private List<TypeReference> kotlinRepositoryReflectionTypeReferences() {
        return new ArrayList<TypeReference>(Arrays.asList(TypeReference.of((String)KOTLIN_COROUTINE_REPOSITORY_TYPE_NAME), TypeReference.of(Repository.class), TypeReference.of(Iterable.class), TypeReference.of((String)"kotlinx.coroutines.flow.Flow"), TypeReference.of((String)"kotlin.collections.Iterable"), TypeReference.of((String)"kotlin.Unit"), TypeReference.of((String)"kotlin.Long"), TypeReference.of((String)"kotlin.Boolean")));
    }

    static boolean isJavaOrPrimitiveType(Class<?> type) {
        return TypeUtils.type(type).isPartOf("java") || ClassUtils.isPrimitiveOrWrapper(type) || ClassUtils.isPrimitiveArray(type);
    }
}

