/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.annotation.ReflectiveRuntimeHintsRegistrar;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.env.Environment;
import org.springframework.core.env.EnvironmentCapable;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.data.repository.aot.generate.RepositoryContributor;
import org.springframework.data.repository.config.AotRepositoryContext;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryRegistrationAotContribution;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.util.TypeContributor;
import org.springframework.util.Assert;

public class RepositoryRegistrationAotProcessor
implements BeanRegistrationAotProcessor,
BeanFactoryAware,
EnvironmentAware,
EnvironmentCapable {
    private final Log logger = LogFactory.getLog(this.getClass());
    private @Nullable ConfigurableListableBeanFactory beanFactory;
    private Environment environment = new StandardEnvironment();
    private Map<String, RepositoryConfiguration<?>> configMap = Collections.emptyMap();

    public @Nullable BeanRegistrationAotContribution processAheadOfTime(RegisteredBean bean) {
        return this.isRepositoryBean(bean) ? this.newRepositoryRegistrationAotContribution(bean) : null;
    }

    protected @Nullable RepositoryContributor contribute(AotRepositoryContext repositoryContext, GenerationContext generationContext) {
        repositoryContext.getResolvedTypes().stream().filter(it -> !RepositoryRegistrationAotContribution.isJavaOrPrimitiveType(it)).forEach(it -> this.contributeType((Class<?>)it, generationContext));
        repositoryContext.getResolvedAnnotations().stream().filter(RepositoryRegistrationAotProcessor::isSpringDataManagedAnnotation).map(MergedAnnotation::getType).forEach(it -> this.contributeType((Class<?>)it, generationContext));
        return null;
    }

    private void registerReflectiveForAggregateRoot(AotRepositoryContext repositoryContext, GenerationContext generationContext) {
        RepositoryInformation information = repositoryContext.getRepositoryInformation();
        ReflectiveRuntimeHintsRegistrar registrar = new ReflectiveRuntimeHintsRegistrar();
        RuntimeHints hints = generationContext.getRuntimeHints();
        Stream.concat(Stream.of(information.getDomainType()), information.getAlternativeDomainTypes().stream()).forEach(it -> registrar.registerRuntimeHints(hints, new Class[]{it}));
    }

    private boolean isRepositoryBean(RegisteredBean bean) {
        return this.getConfigMap().containsKey(bean.getBeanName());
    }

    protected @Nullable RepositoryRegistrationAotContribution newRepositoryRegistrationAotContribution(RegisteredBean repositoryBean) {
        RepositoryRegistrationAotContribution contribution = RepositoryRegistrationAotContribution.load(this, repositoryBean);
        if (contribution == null) {
            return null;
        }
        return contribution.withModuleContribution((repositoryContext, generationContext) -> {
            this.registerReflectiveForAggregateRoot((AotRepositoryContext)repositoryContext, (GenerationContext)generationContext);
            return this.contribute((AotRepositoryContext)repositoryContext, (GenerationContext)generationContext);
        });
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory, () -> "AutowiredAnnotationBeanPostProcessor requires a ConfigurableListableBeanFactory: " + String.valueOf(beanFactory));
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setConfigMap(Map<String, RepositoryConfiguration<?>> configMap) {
        this.configMap = configMap;
    }

    public Map<String, RepositoryConfiguration<?>> getConfigMap() {
        return this.configMap;
    }

    protected ConfigurableListableBeanFactory getBeanFactory() {
        if (this.beanFactory == null) {
            throw new IllegalStateException("No BeanFactory available. Make sure to set the BeanFactory before using this processor.");
        }
        return this.beanFactory;
    }

    protected @Nullable RepositoryConfiguration<?> getRepositoryMetadata(RegisteredBean bean) {
        return this.getConfigMap().get(bean.getBeanName());
    }

    protected void contributeType(Class<?> type, GenerationContext generationContext) {
        TypeContributor.contribute(type, it -> true, generationContext);
    }

    protected Log getLogger() {
        return this.logger;
    }

    protected void logDebug(String message, Object ... arguments) {
        this.logAt(Log::isDebugEnabled, Log::debug, message, arguments);
    }

    protected void logTrace(String message, Object ... arguments) {
        this.logAt(Log::isTraceEnabled, Log::trace, message, arguments);
    }

    private void logAt(Predicate<Log> logLevelPredicate, BiConsumer<Log, String> logOperation, String message, Object ... arguments) {
        Log logger = this.getLogger();
        if (logLevelPredicate.test(logger)) {
            logOperation.accept(logger, String.format(message, arguments));
        }
    }

    private static boolean isSpringDataManagedAnnotation(MergedAnnotation<?> annotation) {
        return RepositoryRegistrationAotProcessor.isSpringDataType(annotation.getType()) || annotation.getMetaTypes().stream().anyMatch(RepositoryRegistrationAotProcessor::isSpringDataType);
    }

    private static boolean isSpringDataType(Class<?> type) {
        return type.getPackageName().startsWith("org.springframework.data");
    }
}

