/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.TypeReference;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.repository.aot.generate.AotRepositoryBuilder;
import org.springframework.data.repository.aot.generate.AotRepositoryClassBuilder;
import org.springframework.data.repository.aot.generate.AotRepositoryConstructorBuilder;
import org.springframework.data.repository.aot.generate.JSONException;
import org.springframework.data.repository.aot.generate.MethodContributor;
import org.springframework.data.repository.config.AotRepositoryContext;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.javapoet.JavaFile;
import org.springframework.javapoet.TypeName;

public class RepositoryContributor {
    private static final Log logger = LogFactory.getLog(RepositoryContributor.class);
    private final AotRepositoryBuilder builder;

    public RepositoryContributor(AotRepositoryContext repositoryContext) {
        this.builder = AotRepositoryBuilder.forRepository(repositoryContext.getRepositoryInformation(), repositoryContext.getModuleName(), this.createProjectionFactory());
    }

    protected ProjectionFactory createProjectionFactory() {
        return new SpelAwareProxyProjectionFactory();
    }

    protected ProjectionFactory getProjectionFactory() {
        return this.builder.getProjectionFactory();
    }

    protected RepositoryInformation getRepositoryInformation() {
        return this.builder.getRepositoryInformation();
    }

    public String getContributedTypeName() {
        return this.builder.getGenerationMetadata().getTargetTypeName().toString();
    }

    public Map<String, TypeName> requiredArgs() {
        return this.builder.getAutowireFields();
    }

    public void contribute(GenerationContext generationContext) {
        String repositoryJson;
        AotRepositoryBuilder.AotBundle aotBundle = this.builder.withClassCustomizer(this::customizeClass).withConstructorCustomizer(this::customizeConstructor).withQueryMethodContributor(this::contributeQueryMethod).build();
        Class<?> repositoryInterface = this.getRepositoryInformation().getRepositoryInterface();
        String repositoryJsonFileName = RepositoryContributor.getRepositoryJsonFileName(repositoryInterface);
        JavaFile javaFile = aotBundle.javaFile();
        String typeName = "%s.%s".formatted(javaFile.packageName, javaFile.typeSpec.name);
        try {
            repositoryJson = aotBundle.metadata().toJson().toString(2);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"------ AOT Repository.json: %s ------\n%s\n-------------------\n".formatted(repositoryJsonFileName, repositoryJson));
            logger.trace((Object)"------ AOT Generated Repository: %s ------\n%s\n-------------------\n".formatted(typeName, javaFile));
        }
        generationContext.getGeneratedFiles().addSourceFile(javaFile);
        generationContext.getGeneratedFiles().addResourceFile(repositoryJsonFileName, (CharSequence)repositoryJson);
        generationContext.getRuntimeHints().reflection().registerType(TypeReference.of((String)typeName), new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS});
    }

    private static String getRepositoryJsonFileName(Class<?> repositoryInterface) {
        return repositoryInterface.getName().replace('.', '/') + ".json";
    }

    protected void customizeClass(AotRepositoryClassBuilder builder) {
    }

    protected void customizeConstructor(AotRepositoryConstructorBuilder builder) {
    }

    protected @Nullable MethodContributor<? extends QueryMethod> contributeQueryMethod(Method method) {
        return null;
    }
}

