/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryInformationSupport;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class DefaultRepositoryInformation
extends RepositoryInformationSupport
implements RepositoryInformation {
    private final Map<Method, Method> methodCache = new ConcurrentHashMap<Method, Method>();
    private final RepositoryComposition composition;
    private final RepositoryComposition baseComposition;

    public DefaultRepositoryInformation(RepositoryMetadata metadata, Class<?> repositoryBaseClass, RepositoryComposition composition) {
        super(() -> metadata, () -> repositoryBaseClass);
        Assert.notNull((Object)composition, (String)"Repository composition must not be null");
        this.composition = composition;
        this.baseComposition = RepositoryComposition.of(RepositoryFragment.structural(repositoryBaseClass)).withArgumentConverter(composition.getArgumentConverter()).withMethodLookup(composition.getMethodLookup());
    }

    @Override
    public Method getTargetClassMethod(Method method) {
        if (this.methodCache.containsKey(method)) {
            return this.methodCache.get(method);
        }
        Method result = this.composition.findMethod(method).orElse(method);
        if (!result.equals(method)) {
            return this.cacheAndReturn(method, result);
        }
        return this.cacheAndReturn(method, this.baseComposition.findMethod(method).orElse(method));
    }

    @Contract(value="_, null -> null; _, !null -> !null")
    private @Nullable Method cacheAndReturn(Method key, @Nullable Method value) {
        if (value != null) {
            ReflectionUtils.makeAccessible((Method)value);
        }
        this.methodCache.put(key, value);
        return value;
    }

    @Override
    public boolean isCustomMethod(Method method) {
        return this.composition.getMethod(method) != null;
    }

    @Override
    public boolean isBaseClassMethod(Method method) {
        Assert.notNull((Object)method, (String)"Method must not be null");
        return this.baseComposition.getMethod(method) != null;
    }

    @Override
    protected boolean isQueryMethodCandidate(Method method) {
        boolean queryMethodCandidate = super.isQueryMethodCandidate(method);
        if (!this.isQueryAnnotationPresentOn(method)) {
            return queryMethodCandidate;
        }
        if (!queryMethodCandidate) {
            return false;
        }
        for (RepositoryFragment<?> fragment : this.getFragments()) {
            if (!fragment.getImplementation().isPresent() || !fragment.hasMethod(method)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<RepositoryFragment<?>> getFragments() {
        return this.composition.getFragments().toSet();
    }

    @Override
    public RepositoryComposition getRepositoryComposition() {
        return this.composition.append(this.baseComposition.getFragments());
    }
}

