/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.framework.Advised;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragments;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragmentsDecorator;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.DecoratingProxy;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.aot.AotContext;
import org.springframework.data.projection.EntityProjectionIntrospector;
import org.springframework.data.projection.TargetAware;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.aot.generate.RepositoryContributor;
import org.springframework.data.repository.config.AotRepositoryBeanDefinitionPropertiesDecorator;
import org.springframework.data.repository.config.AotRepositoryContext;
import org.springframework.data.repository.config.DefaultAotRepositoryContext;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryRegistrationAotProcessor;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.util.Predicates;
import org.springframework.data.util.QTypeContributor;
import org.springframework.data.util.TypeContributor;
import org.springframework.data.util.TypeUtils;
import org.springframework.javapoet.CodeBlock;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class RepositoryRegistrationAotContribution
implements BeanRegistrationAotContribution {
    private static final String KOTLIN_COROUTINE_REPOSITORY_TYPE_NAME = "org.springframework.data.repository.kotlin.CoroutineCrudRepository";
    private @Nullable RepositoryContributor repositoryContributor;
    private @Nullable AotRepositoryContext repositoryContext;
    private @Nullable BiFunction<AotRepositoryContext, GenerationContext, @Nullable RepositoryContributor> moduleContribution;
    private final RepositoryRegistrationAotProcessor aotProcessor;

    protected RepositoryRegistrationAotContribution(RepositoryRegistrationAotProcessor processor) {
        Assert.notNull((Object)processor, (String)"RepositoryRegistrationAotProcessor must not be null");
        this.aotProcessor = processor;
    }

    public static RepositoryRegistrationAotContribution fromProcessor(RepositoryRegistrationAotProcessor processor) {
        return new RepositoryRegistrationAotContribution(processor);
    }

    protected ConfigurableListableBeanFactory getBeanFactory() {
        return this.getRepositoryRegistrationAotProcessor().getBeanFactory();
    }

    protected @Nullable BiFunction<AotRepositoryContext, GenerationContext, @Nullable RepositoryContributor> getModuleContribution() {
        return this.moduleContribution;
    }

    protected AotRepositoryContext getRepositoryContext() {
        Assert.state((this.repositoryContext != null ? 1 : 0) != 0, (String)"The AOT RepositoryContext was not properly initialized; did you call the forBean(:RegisteredBean) method");
        return this.repositoryContext;
    }

    protected RepositoryRegistrationAotProcessor getRepositoryRegistrationAotProcessor() {
        return this.aotProcessor;
    }

    public RepositoryInformation getRepositoryInformation() {
        return this.getRepositoryContext().getRepositoryInformation();
    }

    private void logTrace(String message, Object ... arguments) {
        this.getRepositoryRegistrationAotProcessor().logTrace(message, arguments);
    }

    public RepositoryRegistrationAotContribution forBean(RegisteredBean repositoryBean) {
        Assert.notNull((Object)repositoryBean, (String)"The RegisteredBean for the repository must not be null");
        RepositoryConfiguration<?> repositoryMetadata = this.getRepositoryRegistrationAotProcessor().getRepositoryMetadata(repositoryBean);
        Assert.state((repositoryMetadata != null ? 1 : 0) != 0, (String)"The RepositoryConfiguration for the repository must not be null");
        this.repositoryContext = this.buildAotRepositoryContext(repositoryBean, repositoryMetadata);
        return this;
    }

    public RepositoryRegistrationAotContribution withModuleContribution(@Nullable BiFunction<AotRepositoryContext, GenerationContext, @Nullable RepositoryContributor> moduleContribution) {
        this.moduleContribution = moduleContribution;
        return this;
    }

    public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
        Assert.state((this.repositoryContext != null ? 1 : 0) != 0, (String)"RepositoryContext cannot be null. Make sure to initialize this class with forBean(\u2026).");
        this.contributeRepositoryInfo(this.repositoryContext, generationContext);
        BiFunction<AotRepositoryContext, GenerationContext, RepositoryContributor> moduleContribution = this.getModuleContribution();
        if (moduleContribution != null && this.repositoryContributor == null) {
            this.repositoryContributor = moduleContribution.apply(this.getRepositoryContext(), generationContext);
            if (this.repositoryContributor != null) {
                this.repositoryContributor.contribute(generationContext);
            }
        }
    }

    public BeanRegistrationCodeFragments customizeBeanRegistrationCodeFragments(GenerationContext generationContext, BeanRegistrationCodeFragments codeFragments) {
        return new BeanRegistrationCodeFragmentsDecorator(codeFragments){

            public CodeBlock generateSetBeanDefinitionPropertiesCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode, RootBeanDefinition beanDefinition, Predicate<String> attributeFilter) {
                if (RepositoryRegistrationAotContribution.this.repositoryContributor == null) {
                    return super.generateSetBeanDefinitionPropertiesCode(generationContext, beanRegistrationCode, beanDefinition, attributeFilter);
                }
                AotRepositoryBeanDefinitionPropertiesDecorator decorator = new AotRepositoryBeanDefinitionPropertiesDecorator(() -> super.generateSetBeanDefinitionPropertiesCode(generationContext, beanRegistrationCode, beanDefinition, attributeFilter), RepositoryRegistrationAotContribution.this.repositoryContributor);
                return decorator.decorate();
            }
        };
    }

    private void contributeRepositoryInfo(AotRepositoryContext repositoryContext, GenerationContext contribution) {
        RepositoryInformation repositoryInformation = this.getRepositoryInformation();
        this.logTrace("Contributing repository information for [%s]", repositoryInformation.getRepositoryInterface());
        contribution.getRuntimeHints().reflection().registerType(repositoryInformation.getRepositoryInterface(), hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS})).registerType(repositoryInformation.getRepositoryBaseClass(), hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS}));
        TypeContributor.contribute(repositoryInformation.getDomainType(), contribution);
        QTypeContributor.contributeEntityPath(repositoryInformation.getDomainType(), contribution, repositoryContext.getClassLoader());
        for (RepositoryFragment<?> fragment : this.getRepositoryInformation().getFragments()) {
            Class<?> repositoryFragmentType = fragment.getSignatureContributor();
            Optional<?> implementation = fragment.getImplementation();
            contribution.getRuntimeHints().reflection().registerType(repositoryFragmentType, hint -> {
                hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS});
                if (!repositoryFragmentType.isInterface()) {
                    hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
                }
            });
            implementation.ifPresent(impl -> contribution.getRuntimeHints().reflection().registerType(impl.getClass(), hint -> {
                hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS});
                if (!impl.getClass().isInterface()) {
                    hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
                }
            }));
        }
        contribution.getRuntimeHints().proxies().registerJdkProxy(new Class[]{repositoryInformation.getRepositoryInterface(), SpringProxy.class, Advised.class, DecoratingProxy.class});
        List<TypeReference> transactionalRepositoryProxyTypeReferences = this.transactionalRepositoryProxyTypeReferences(repositoryInformation);
        contribution.getRuntimeHints().proxies().registerJdkProxy(transactionalRepositoryProxyTypeReferences.toArray(new TypeReference[0]));
        if (this.isComponentAnnotatedRepository(repositoryInformation)) {
            transactionalRepositoryProxyTypeReferences.add(TypeReference.of(Serializable.class));
            contribution.getRuntimeHints().proxies().registerJdkProxy(transactionalRepositoryProxyTypeReferences.toArray(new TypeReference[0]));
        }
        if (repositoryInformation.isReactiveRepository()) {
            // empty if block
        }
        if (this.isKotlinCoroutineRepository(repositoryContext, repositoryInformation)) {
            contribution.getRuntimeHints().reflection().registerTypes(this.kotlinRepositoryReflectionTypeReferences(), hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INTROSPECT_PUBLIC_METHODS}));
        }
        repositoryInformation.getQueryMethods().stream().map(repositoryInformation::getReturnedDomainClass).filter(Class::isInterface).forEach(type -> {
            if (EntityProjectionIntrospector.ProjectionPredicate.typeHierarchy().test((Class<?>)type, repositoryInformation.getDomainType())) {
                this.contributeProjection((Class<?>)type, contribution);
            }
        });
    }

    private boolean isComponentAnnotatedRepository(RepositoryInformation repositoryInformation) {
        return AnnotationUtils.findAnnotation(repositoryInformation.getRepositoryInterface(), Component.class) != null;
    }

    private boolean isKotlinCoroutineRepository(AotRepositoryContext repositoryContext, RepositoryInformation repositoryInformation) {
        return repositoryContext.introspectType(KOTLIN_COROUTINE_REPOSITORY_TYPE_NAME).resolveType().filter(it -> ClassUtils.isAssignable((Class)it, repositoryInformation.getRepositoryInterface())).isPresent();
    }

    private List<TypeReference> kotlinRepositoryReflectionTypeReferences() {
        return new ArrayList<TypeReference>(Arrays.asList(TypeReference.of((String)KOTLIN_COROUTINE_REPOSITORY_TYPE_NAME), TypeReference.of(Repository.class), TypeReference.of(Iterable.class), TypeReference.of((String)"kotlinx.coroutines.flow.Flow"), TypeReference.of((String)"kotlin.collections.Iterable"), TypeReference.of((String)"kotlin.Unit"), TypeReference.of((String)"kotlin.Long"), TypeReference.of((String)"kotlin.Boolean")));
    }

    private List<TypeReference> transactionalRepositoryProxyTypeReferences(RepositoryInformation repositoryInformation) {
        return new ArrayList<TypeReference>(Arrays.asList(TypeReference.of(repositoryInformation.getRepositoryInterface()), TypeReference.of(Repository.class), TypeReference.of((String)"org.springframework.transaction.interceptor.TransactionalProxy"), TypeReference.of((String)"org.springframework.aop.framework.Advised"), TypeReference.of(DecoratingProxy.class)));
    }

    private void contributeProjection(Class<?> type, GenerationContext generationContext) {
        generationContext.getRuntimeHints().proxies().registerJdkProxy(new Class[]{type, TargetAware.class, SpringProxy.class, DecoratingProxy.class});
    }

    static boolean isJavaOrPrimitiveType(Class<?> type) {
        return TypeUtils.type(type).isPartOf("java") || ClassUtils.isPrimitiveOrWrapper(type) || ClassUtils.isPrimitiveArray(type);
    }

    public Predicate<Class<?>> typeFilter() {
        return Predicates.isTrue();
    }

    private DefaultAotRepositoryContext buildAotRepositoryContext(RegisteredBean bean, RepositoryConfiguration<?> repositoryMetadata) {
        DefaultAotRepositoryContext repositoryContext = new DefaultAotRepositoryContext(AotContext.from((BeanFactory)this.getBeanFactory(), this.getRepositoryRegistrationAotProcessor().getEnvironment()));
        RepositoryFactoryBeanSupport rfbs = (RepositoryFactoryBeanSupport)bean.getBeanFactory().getBean("&" + bean.getBeanName(), RepositoryFactoryBeanSupport.class);
        repositoryContext.setBeanName(bean.getBeanName());
        repositoryContext.setBasePackages(repositoryMetadata.getBasePackages().toSet());
        repositoryContext.setIdentifyingAnnotations(this.resolveIdentifyingAnnotations());
        repositoryContext.setRepositoryInformation(rfbs.getRepositoryInformation());
        return repositoryContext;
    }

    private Set<Class<? extends Annotation>> resolveIdentifyingAnnotations() {
        return Collections.emptySet();
    }
}

