/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.generate.ClassNameGenerator;
import org.springframework.aot.generate.Generated;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.aot.generate.AotFragmentTarget;
import org.springframework.data.repository.aot.generate.AotQueryMethodGenerationContext;
import org.springframework.data.repository.aot.generate.AotRepositoryConstructorBuilder;
import org.springframework.data.repository.aot.generate.AotRepositoryFragmentMetadata;
import org.springframework.data.repository.aot.generate.AotRepositoryMetadata;
import org.springframework.data.repository.aot.generate.AotRepositoryMethod;
import org.springframework.data.repository.aot.generate.JSONObject;
import org.springframework.data.repository.aot.generate.MethodContributor;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.FieldSpec;
import org.springframework.javapoet.JavaFile;
import org.springframework.javapoet.TypeName;
import org.springframework.javapoet.TypeSpec;

class AotRepositoryBuilder {
    private final RepositoryInformation repositoryInformation;
    private final ProjectionFactory projectionFactory;
    private final AotRepositoryFragmentMetadata generationMetadata;
    private @Nullable Consumer<AotRepositoryConstructorBuilder> constructorCustomizer;
    private @Nullable BiFunction<Method, RepositoryInformation, @Nullable MethodContributor<? extends QueryMethod>> methodContributorFunction;
    private ClassCustomizer customizer;

    private AotRepositoryBuilder(RepositoryInformation repositoryInformation, ProjectionFactory projectionFactory) {
        this.repositoryInformation = repositoryInformation;
        this.projectionFactory = projectionFactory;
        this.generationMetadata = new AotRepositoryFragmentMetadata(this.className());
        this.generationMetadata.addField(FieldSpec.builder((TypeName)TypeName.get(Log.class), (String)"logger", (javax.lang.model.element.Modifier[])new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PRIVATE, javax.lang.model.element.Modifier.STATIC, javax.lang.model.element.Modifier.FINAL}).initializer("$T.getLog($T.class)", new Object[]{TypeName.get(LogFactory.class), this.generationMetadata.getTargetTypeName()}).build());
        this.customizer = (info, metadata, builder) -> {};
    }

    public static <M extends QueryMethod> AotRepositoryBuilder forRepository(RepositoryInformation repositoryInformation, ProjectionFactory projectionFactory) {
        return new AotRepositoryBuilder(repositoryInformation, projectionFactory);
    }

    public AotRepositoryBuilder withConstructorCustomizer(Consumer<AotRepositoryConstructorBuilder> constructorCustomizer) {
        this.constructorCustomizer = constructorCustomizer;
        return this;
    }

    public AotRepositoryBuilder withQueryMethodContributor(BiFunction<Method, RepositoryInformation, @Nullable MethodContributor<? extends QueryMethod>> methodContributorFunction) {
        this.methodContributorFunction = methodContributorFunction;
        return this;
    }

    public AotRepositoryBuilder withClassCustomizer(ClassCustomizer classCustomizer) {
        this.customizer = classCustomizer;
        return this;
    }

    public AotBundle build() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.generationMetadata.getTargetTypeName()).addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addAnnotation(Generated.class).addJavadoc("AOT generated repository implementation for {@link $T}.\n", new Object[]{this.repositoryInformation.getRepositoryInterface()});
        AotRepositoryConstructorBuilder constructorBuilder = new AotRepositoryConstructorBuilder(this.repositoryInformation, this.generationMetadata);
        if (this.constructorCustomizer != null) {
            this.constructorCustomizer.accept(constructorBuilder);
        }
        builder.addMethod(constructorBuilder.buildConstructor());
        ArrayList<AotRepositoryMethod> methodMetadata = new ArrayList<AotRepositoryMethod>();
        AotRepositoryMetadata.RepositoryType repositoryType = this.repositoryInformation.isReactiveRepository() ? AotRepositoryMetadata.RepositoryType.REACTIVE : AotRepositoryMetadata.RepositoryType.IMPERATIVE;
        RepositoryComposition repositoryComposition = this.repositoryInformation.getRepositoryComposition();
        Arrays.stream(this.repositoryInformation.getRepositoryInterface().getMethods()).sorted(Comparator.comparing(it -> it.getDeclaringClass().getName()).thenComparing(Method::getName).thenComparing(Method::getParameterCount).thenComparing(Method::toString)).forEach(method -> this.contributeMethod((Method)method, repositoryComposition, (List<AotRepositoryMethod>)methodMetadata, builder));
        this.generationMetadata.getFields().values().forEach(arg_0 -> ((TypeSpec.Builder)builder).addField(arg_0));
        this.customizer.customize(this.repositoryInformation, this.generationMetadata, builder);
        JavaFile javaFile = JavaFile.builder((String)this.packageName(), (TypeSpec)builder.build()).build();
        AotRepositoryMetadata metadata = new AotRepositoryMetadata(this.repositoryInformation.getRepositoryInterface().getName(), "", repositoryType, methodMetadata);
        return new AotBundle(javaFile, metadata.toJson());
    }

    private void contributeMethod(Method method, RepositoryComposition repositoryComposition, List<AotRepositoryMethod> methodMetadata, TypeSpec.Builder builder) {
        MethodContributor<? extends QueryMethod> contributor;
        if (this.repositoryInformation.isCustomMethod(method) || this.repositoryInformation.isBaseClassMethod(method)) {
            RepositoryFragment<?> fragment = repositoryComposition.findFragment(method);
            if (fragment != null) {
                methodMetadata.add(this.getFragmentMetadata(method, fragment));
            }
            return;
        }
        if (method.isBridge() || method.isDefault() || Modifier.isStatic(method.getModifiers())) {
            return;
        }
        if (this.repositoryInformation.isQueryMethod(method) && this.methodContributorFunction != null && (contributor = this.methodContributorFunction.apply(method, this.repositoryInformation)) != null) {
            if (contributor.contributesMethodSpec() && !this.repositoryInformation.isReactiveRepository()) {
                AotQueryMethodGenerationContext context = new AotQueryMethodGenerationContext(this.repositoryInformation, method, contributor.getQueryMethod(), this.generationMetadata);
                builder.addMethod(contributor.contribute(context));
            }
            methodMetadata.add(new AotRepositoryMethod(method.getName(), method.toGenericString(), contributor.getMetadata(), null));
        }
    }

    private AotRepositoryMethod getFragmentMetadata(Method method, RepositoryFragment<?> fragment) {
        String signature = fragment.getSignatureContributor().getName();
        String implementation = fragment.getImplementation().map(it -> it.getClass().getName()).orElse(null);
        AotFragmentTarget fragmentTarget = new AotFragmentTarget(signature, implementation);
        return new AotRepositoryMethod(method.getName(), method.toGenericString(), null, fragmentTarget);
    }

    public AotRepositoryFragmentMetadata getGenerationMetadata() {
        return this.generationMetadata;
    }

    private ClassName className() {
        return new ClassNameGenerator(ClassName.get((String)this.packageName(), (String)this.typeName(), (String[])new String[0])).generateClassName("Aot", null);
    }

    private String packageName() {
        return this.repositoryInformation.getRepositoryInterface().getPackageName();
    }

    private String typeName() {
        return "%sImpl".formatted(this.repositoryInformation.getRepositoryInterface().getSimpleName());
    }

    public Map<String, TypeName> getAutowireFields() {
        LinkedHashMap<String, TypeName> autowireFields = new LinkedHashMap<String, TypeName>(this.generationMetadata.getConstructorArguments().size());
        for (Map.Entry<String, AotRepositoryFragmentMetadata.ConstructorArgument> entry : this.generationMetadata.getConstructorArguments().entrySet()) {
            autowireFields.put(entry.getKey(), entry.getValue().typeName());
        }
        return autowireFields;
    }

    public RepositoryInformation getRepositoryInformation() {
        return this.repositoryInformation;
    }

    public ProjectionFactory getProjectionFactory() {
        return this.projectionFactory;
    }

    public static interface ClassCustomizer {
        public void customize(RepositoryInformation var1, AotRepositoryFragmentMetadata var2, TypeSpec.Builder var3);
    }

    record AotBundle(JavaFile javaFile, JSONObject metadata) {
    }
}

