/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.EventPublishingRepositoryProxyPostProcessor;
import org.springframework.data.repository.core.support.PropertiesBasedNamedQueries;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFactoryCustomizer;
import org.springframework.data.repository.core.support.RepositoryFactoryInformation;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodValueEvaluationContextAccessor;
import org.springframework.data.spel.EvaluationContextProvider;
import org.springframework.data.util.Lazy;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public abstract class RepositoryFactoryBeanSupport<T extends Repository<S, ID>, S, ID>
implements InitializingBean,
RepositoryFactoryInformation<S, ID>,
FactoryBean<T>,
ApplicationEventPublisherAware,
BeanClassLoaderAware,
BeanFactoryAware,
EnvironmentAware {
    private final Class<? extends T> repositoryInterface;
    private RepositoryFactorySupport factory;
    private boolean exposeMetadata;
    private QueryLookupStrategy.Key queryLookupStrategyKey;
    private Optional<Class<?>> repositoryBaseClass = Optional.empty();
    private Optional<Object> customImplementation = Optional.empty();
    private Optional<RepositoryComposition.RepositoryFragments> repositoryFragments = Optional.empty();
    private NamedQueries namedQueries = PropertiesBasedNamedQueries.EMPTY;
    private Optional<MappingContext<?, ?>> mappingContext = Optional.empty();
    private ClassLoader classLoader;
    private ApplicationEventPublisher publisher;
    private BeanFactory beanFactory;
    private Environment environment;
    private boolean lazyInit = false;
    private Optional<EvaluationContextProvider> evaluationContextProvider = Optional.empty();
    private final List<RepositoryFactoryCustomizer> repositoryFactoryCustomizers = new ArrayList<RepositoryFactoryCustomizer>();
    private Lazy<T> repository;
    private RepositoryMetadata repositoryMetadata;

    protected RepositoryFactoryBeanSupport(Class<? extends T> repositoryInterface) {
        Assert.notNull(repositoryInterface, (String)"Repository interface must not be null");
        this.repositoryInterface = repositoryInterface;
    }

    public void setRepositoryBaseClass(Class<?> repositoryBaseClass) {
        this.repositoryBaseClass = Optional.ofNullable(repositoryBaseClass);
    }

    public void setExposeMetadata(boolean exposeMetadata) {
        this.exposeMetadata = exposeMetadata;
    }

    public void setQueryLookupStrategyKey(QueryLookupStrategy.Key queryLookupStrategyKey) {
        this.queryLookupStrategyKey = queryLookupStrategyKey;
    }

    public void setCustomImplementation(Object customImplementation) {
        this.customImplementation = Optional.of(customImplementation);
    }

    public void setRepositoryFragments(RepositoryComposition.RepositoryFragments repositoryFragments) {
        this.repositoryFragments = Optional.of(repositoryFragments);
    }

    public void setNamedQueries(NamedQueries namedQueries) {
        this.namedQueries = namedQueries;
    }

    protected void setMappingContext(MappingContext<?, ?> mappingContext) {
        this.mappingContext = Optional.of(mappingContext);
    }

    public void setEvaluationContextProvider(EvaluationContextProvider evaluationContextProvider) {
        this.evaluationContextProvider = Optional.of(evaluationContextProvider);
    }

    public void addRepositoryFactoryCustomizer(RepositoryFactoryCustomizer customizer) {
        Assert.notNull((Object)customizer, (String)"RepositoryFactoryCustomizer must not be null");
        this.repositoryFactoryCustomizers.add(customizer);
    }

    public void setLazyInit(boolean lazy) {
        this.lazyInit = lazy;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        if (this.evaluationContextProvider.isEmpty() && beanFactory instanceof ListableBeanFactory) {
            ListableBeanFactory lbf = (ListableBeanFactory)beanFactory;
            this.evaluationContextProvider = this.createDefaultEvaluationContextProvider(lbf);
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    protected Optional<EvaluationContextProvider> createDefaultEvaluationContextProvider(ListableBeanFactory beanFactory) {
        return Optional.of(QueryMethodValueEvaluationContextAccessor.createEvaluationContextProvider(beanFactory));
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public EntityInformation<S, ID> getEntityInformation() {
        return this.factory.getEntityInformation(this.repositoryMetadata.getDomainType());
    }

    @Override
    public RepositoryInformation getRepositoryInformation() {
        RepositoryComposition.RepositoryFragments fragments = this.customImplementation.map(xva$0 -> RepositoryComposition.RepositoryFragments.just(xva$0)).orElse(RepositoryComposition.RepositoryFragments.empty());
        return this.factory.getRepositoryInformation(this.repositoryMetadata, fragments);
    }

    @Override
    public PersistentEntity<?, ?> getPersistentEntity() {
        return this.mappingContext.orElseThrow(() -> new IllegalStateException("No MappingContext available")).getRequiredPersistentEntity(this.repositoryMetadata.getDomainType());
    }

    @Override
    public List<QueryMethod> getQueryMethods() {
        return this.factory.getQueryMethods();
    }

    @NonNull
    public T getObject() {
        return (T)((Repository)this.repository.get());
    }

    @NonNull
    public Class<? extends T> getObjectType() {
        return this.repositoryInterface;
    }

    public void afterPropertiesSet() {
        this.factory = this.createRepositoryFactory();
        this.factory.setExposeMetadata(this.exposeMetadata);
        this.factory.setQueryLookupStrategyKey(this.queryLookupStrategyKey);
        this.factory.setNamedQueries(this.namedQueries);
        this.factory.setEvaluationContextProvider(this.evaluationContextProvider.orElse(QueryMethodValueEvaluationContextAccessor.DEFAULT_CONTEXT_PROVIDER));
        this.factory.setBeanClassLoader(this.classLoader);
        this.factory.setBeanFactory(this.beanFactory);
        if (this.publisher != null) {
            this.factory.addRepositoryProxyPostProcessor(new EventPublishingRepositoryProxyPostProcessor(this.publisher));
        }
        if (this.environment != null) {
            this.factory.setEnvironment(this.environment);
        }
        this.repositoryBaseClass.ifPresent(this.factory::setRepositoryBaseClass);
        this.repositoryFactoryCustomizers.forEach(customizer -> customizer.customize(this.factory));
        RepositoryComposition.RepositoryFragments customImplementationFragment = this.customImplementation.map(xva$0 -> RepositoryComposition.RepositoryFragments.just(xva$0)).orElseGet(RepositoryComposition.RepositoryFragments::empty);
        RepositoryComposition.RepositoryFragments repositoryFragmentsToUse = this.repositoryFragments.orElseGet(RepositoryComposition.RepositoryFragments::empty).append(customImplementationFragment);
        this.repositoryMetadata = this.factory.getRepositoryMetadata(this.repositoryInterface);
        this.repository = Lazy.of(() -> (Repository)this.factory.getRepository(this.repositoryInterface, repositoryFragmentsToUse));
        this.mappingContext.ifPresent(it -> it.getPersistentEntity(this.repositoryMetadata.getDomainType()));
        if (!this.lazyInit) {
            this.repository.get();
        }
    }

    protected abstract RepositoryFactorySupport createRepositoryFactory();
}

