/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Window;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class WindowIterator<T>
implements Iterator<T> {
    private final Function<ScrollPosition, Window<T>> windowFunction;
    private ScrollPosition currentPosition;
    @Nullable
    private Window<T> currentWindow;
    @Nullable
    private Iterator<T> currentIterator;

    public static <T> WindowIteratorBuilder<T> of(Function<ScrollPosition, Window<T>> windowFunction) {
        return new WindowIteratorBuilder<T>(windowFunction);
    }

    WindowIterator(Function<ScrollPosition, Window<T>> windowFunction, ScrollPosition position) {
        this.windowFunction = windowFunction;
        this.currentPosition = position;
    }

    @Override
    public boolean hasNext() {
        while (true) {
            if (this.currentWindow == null) {
                this.currentWindow = this.windowFunction.apply(this.currentPosition);
            }
            if (this.currentIterator == null && this.currentWindow != null) {
                this.currentIterator = this.currentWindow.iterator();
            }
            if (this.currentIterator == null) break;
            if (this.currentIterator.hasNext()) {
                return true;
            }
            if (this.currentWindow == null || !this.currentWindow.hasNext()) break;
            this.currentPosition = this.currentWindow.positionAt(this.currentWindow.size() - 1);
            this.currentIterator = null;
            this.currentWindow = null;
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentIterator.next();
    }

    public static class WindowIteratorBuilder<T> {
        private final Function<ScrollPosition, Window<T>> windowFunction;

        WindowIteratorBuilder(Function<ScrollPosition, Window<T>> windowFunction) {
            Assert.notNull(windowFunction, (String)"WindowFunction must not be null");
            this.windowFunction = windowFunction;
        }

        public WindowIterator<T> startingAt(ScrollPosition position) {
            Assert.notNull((Object)position, (String)"ScrollPosition must not be null");
            return new WindowIterator<T>(this.windowFunction, position);
        }
    }
}

