/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class KeysetScrollPosition
implements ScrollPosition {
    private static final KeysetScrollPosition initial = new KeysetScrollPosition(Collections.emptyMap(), Direction.Forward);
    private final Map<String, Object> keys;
    private final Direction direction;

    private KeysetScrollPosition(Map<String, Object> keys, Direction direction) {
        this.keys = keys;
        this.direction = direction;
    }

    public static KeysetScrollPosition initial() {
        return initial;
    }

    public static KeysetScrollPosition of(Map<String, ?> keys) {
        return KeysetScrollPosition.of(keys, Direction.Forward);
    }

    public static KeysetScrollPosition of(Map<String, ?> keys, Direction direction) {
        Assert.notNull(keys, (String)"Keys must not be null");
        Assert.notNull((Object)((Object)direction), (String)"Direction must not be null");
        if (keys.isEmpty()) {
            return KeysetScrollPosition.initial();
        }
        return new KeysetScrollPosition(Collections.unmodifiableMap(new LinkedHashMap(keys)), direction);
    }

    @Override
    public boolean isInitial() {
        return this.keys.isEmpty();
    }

    public Map<String, Object> getKeys() {
        return this.keys;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeysetScrollPosition that = (KeysetScrollPosition)o;
        return ObjectUtils.nullSafeEquals(this.keys, that.keys) && this.direction == that.direction;
    }

    public int hashCode() {
        int result = 17;
        result += 31 * ObjectUtils.nullSafeHashCode(this.keys);
        return result += 31 * ObjectUtils.nullSafeHashCode((Object)((Object)this.direction));
    }

    public String toString() {
        return String.format("KeysetScrollPosition [%s, %s]", new Object[]{this.direction, this.keys});
    }

    public static enum Direction {
        Forward,
        Backward;

    }
}

