/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aot;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.ResolvableType;
import org.springframework.data.aot.Predicates;
import org.springframework.data.aot.TypeUtils;
import org.springframework.data.util.Lazy;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class TypeCollector {
    private static final Log logger = LogFactory.getLog(TypeCollector.class);
    static final Set<String> EXCLUDED_DOMAINS = new HashSet<String>(Arrays.asList("java", "sun.", "jdk.", "reactor.", "kotlinx.", "kotlin.", "org.springframework.core.", "org.springframework.data.mapping.", "org.springframework.data.repository.", "org.springframework.boot.", "org.springframework.core."));
    private final Predicate<Class<?>> excludedDomainsFilter = type -> {
        String packageName = type.getPackageName();
        return EXCLUDED_DOMAINS.stream().noneMatch(packageName::startsWith);
    };
    private Predicate<Class<?>> typeFilter = this.excludedDomainsFilter;
    private final Predicate<Method> methodFilter = this.createMethodFilter();
    private Predicate<Field> fieldFilter = this.createFieldFilter();

    public TypeCollector filterFields(Predicate<Field> filter) {
        this.fieldFilter = filter.and(filter);
        return this;
    }

    public TypeCollector filterTypes(Predicate<Class<?>> filter) {
        this.typeFilter = this.typeFilter.and(filter);
        return this;
    }

    public static ReachableTypes inspect(Class<?> ... types) {
        return TypeCollector.inspect(Arrays.asList(types));
    }

    public static ReachableTypes inspect(Collection<Class<?>> types) {
        return new ReachableTypes(new TypeCollector(), types);
    }

    private void process(Class<?> root, Consumer<ResolvableType> consumer) {
        this.processType(ResolvableType.forType(root), new InspectionCache(), consumer);
    }

    private void processType(ResolvableType type, InspectionCache cache, Consumer<ResolvableType> callback) {
        if (ResolvableType.NONE.equals((Object)type) || cache.contains(type) || type.toClass().isSynthetic()) {
            return;
        }
        cache.add(type);
        if (this.typeFilter.test(type.toClass())) {
            callback.accept(type);
        }
        LinkedHashSet<Type> additionalTypes = new LinkedHashSet<Type>();
        additionalTypes.addAll(TypeUtils.resolveTypesInSignature(type));
        additionalTypes.addAll(this.visitConstructorsOfType(type));
        additionalTypes.addAll(this.visitMethodsOfType(type));
        additionalTypes.addAll(this.visitFieldsOfType(type));
        if (!ObjectUtils.isEmpty((Object[])type.toClass().getDeclaredClasses())) {
            additionalTypes.addAll(Arrays.asList(type.toClass().getDeclaredClasses()));
        }
        for (Type discoveredType : additionalTypes) {
            this.processType(ResolvableType.forType((Type)discoveredType, (ResolvableType)type), cache, callback);
        }
    }

    Set<Type> visitConstructorsOfType(ResolvableType type) {
        if (!this.typeFilter.test(type.toClass())) {
            return Collections.emptySet();
        }
        LinkedHashSet discoveredTypes = new LinkedHashSet();
        for (Constructor<?> constructor : type.toClass().getDeclaredConstructors()) {
            for (Class<?> signatureType : TypeUtils.resolveTypesInSignature(type.toClass(), constructor)) {
                if (!this.typeFilter.test(signatureType)) continue;
                discoveredTypes.add(signatureType);
            }
        }
        return new HashSet<Type>(discoveredTypes);
    }

    Set<Type> visitMethodsOfType(ResolvableType type) {
        if (!this.typeFilter.test(type.toClass())) {
            return Collections.emptySet();
        }
        LinkedHashSet discoveredTypes = new LinkedHashSet();
        try {
            ReflectionUtils.doWithLocalMethods((Class)type.toClass(), method -> {
                if (!this.methodFilter.test(method)) {
                    return;
                }
                for (Class<?> signatureType : TypeUtils.resolveTypesInSignature(type.toClass(), method)) {
                    if (!this.typeFilter.test(signatureType)) continue;
                    discoveredTypes.add(signatureType);
                }
            });
        }
        catch (Exception cause) {
            logger.warn((Object)cause);
        }
        return new HashSet<Type>(discoveredTypes);
    }

    Set<Type> visitFieldsOfType(ResolvableType type) {
        LinkedHashSet<Type> discoveredTypes = new LinkedHashSet<Type>();
        ReflectionUtils.doWithLocalFields((Class)type.toClass(), field -> {
            if (!this.fieldFilter.test(field)) {
                return;
            }
            for (Class<?> signatureType : TypeUtils.resolveTypesInSignature(ResolvableType.forField((Field)field, (ResolvableType)type))) {
                if (!this.typeFilter.test(signatureType)) continue;
                discoveredTypes.add(signatureType);
            }
        });
        return discoveredTypes;
    }

    private Predicate<Method> createMethodFilter() {
        Predicate<Method> excludedDomainsPredicate = methodToTest -> this.excludedDomainsFilter.test(methodToTest.getDeclaringClass());
        Predicate<Method> excludedMethodsPredicate = Predicates.IS_BRIDGE_METHOD.or(Predicates.IS_STATIC).or(Predicates.IS_SYNTHETIC).or(Predicates.IS_NATIVE).or(Predicates.IS_PRIVATE).or(Predicates.IS_PROTECTED).or(Predicates.IS_OBJECT_MEMBER).or(Predicates.IS_HIBERNATE_MEMBER).or(Predicates.IS_ENUM_MEMBER).or(excludedDomainsPredicate.negate());
        return excludedMethodsPredicate.negate();
    }

    private Predicate<Field> createFieldFilter() {
        Predicate<Member> excludedFieldPredicate = Predicates.IS_HIBERNATE_MEMBER.or(Predicates.IS_SYNTHETIC).or(Predicates.IS_JAVA);
        return excludedFieldPredicate.negate();
    }

    public static class ReachableTypes {
        private final Iterable<Class<?>> roots;
        private final Lazy<List<Class<?>>> reachableTypes = Lazy.of(this::collect);
        private final TypeCollector typeCollector;

        public ReachableTypes(TypeCollector typeCollector, Iterable<Class<?>> roots) {
            this.typeCollector = typeCollector;
            this.roots = roots;
        }

        public void forEach(Consumer<ResolvableType> consumer) {
            this.roots.forEach((? super T it) -> this.typeCollector.process((Class<?>)it, consumer));
        }

        public List<Class<?>> list() {
            return this.reachableTypes.get();
        }

        private List<Class<?>> collect() {
            ArrayList target = new ArrayList();
            this.forEach(it -> target.add(it.toClass()));
            return target;
        }
    }

    static class InspectionCache {
        private final Map<String, ResolvableType> mutableCache = new LinkedHashMap<String, ResolvableType>();

        InspectionCache() {
        }

        public void add(ResolvableType resolvableType) {
            this.mutableCache.put(resolvableType.toString(), resolvableType);
        }

        public void clear() {
            this.mutableCache.clear();
        }

        public boolean contains(ResolvableType key) {
            return this.mutableCache.containsKey(key.toString());
        }

        public boolean isEmpty() {
            return this.mutableCache.isEmpty();
        }

        public int size() {
            return this.mutableCache.size();
        }
    }
}

