/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aot;

import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.data.aot.AotContext;
import org.springframework.data.aot.AotRepositoryContext;
import org.springframework.data.aot.TypeCollector;
import org.springframework.data.aot.TypeUtils;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.util.Lazy;

class DefaultAotRepositoryContext
implements AotRepositoryContext {
    private final AotContext aotContext;
    private final Lazy<Set<MergedAnnotation<Annotation>>> resolvedAnnotations = Lazy.of(this::discoverAnnotations);
    private final Lazy<Set<Class<?>>> managedTypes = Lazy.of(this::discoverTypes);
    private RepositoryInformation repositoryInformation;
    private Set<String> basePackages;
    private Set<Class<? extends Annotation>> identifyingAnnotations;
    private String beanName;

    public DefaultAotRepositoryContext(AotContext aotContext) {
        this.aotContext = aotContext;
    }

    public AotContext getAotContext() {
        return this.aotContext;
    }

    @Override
    public ConfigurableListableBeanFactory getBeanFactory() {
        return this.getAotContext().getBeanFactory();
    }

    @Override
    public Set<String> getBasePackages() {
        return this.basePackages;
    }

    public void setBasePackages(Set<String> basePackages) {
        this.basePackages = basePackages;
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    @Override
    public Set<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return this.identifyingAnnotations;
    }

    public void setIdentifyingAnnotations(Set<Class<? extends Annotation>> identifyingAnnotations) {
        this.identifyingAnnotations = identifyingAnnotations;
    }

    @Override
    public RepositoryInformation getRepositoryInformation() {
        return this.repositoryInformation;
    }

    public void setRepositoryInformation(RepositoryInformation repositoryInformation) {
        this.repositoryInformation = repositoryInformation;
    }

    @Override
    public Set<MergedAnnotation<Annotation>> getResolvedAnnotations() {
        return this.resolvedAnnotations.get();
    }

    @Override
    public Set<Class<?>> getResolvedTypes() {
        return this.managedTypes.get();
    }

    @Override
    public AotContext.TypeIntrospector introspectType(String typeName) {
        return this.aotContext.introspectType(typeName);
    }

    @Override
    public AotContext.IntrospectedBeanDefinition introspectBeanDefinition(String beanName) {
        return this.aotContext.introspectBeanDefinition(beanName);
    }

    protected Set<MergedAnnotation<Annotation>> discoverAnnotations() {
        Set annotations = this.getResolvedTypes().stream().flatMap(type -> TypeUtils.resolveUsedAnnotations(type).stream()).collect(Collectors.toCollection(LinkedHashSet::new));
        annotations.addAll(TypeUtils.resolveUsedAnnotations(this.repositoryInformation.getRepositoryInterface()));
        return annotations;
    }

    protected Set<Class<?>> discoverTypes() {
        LinkedHashSet types = new LinkedHashSet(TypeCollector.inspect(this.repositoryInformation.getDomainType()).list());
        this.repositoryInformation.getQueryMethods().flatMap(it -> TypeUtils.resolveTypesInSignature(this.repositoryInformation.getRepositoryInterface(), it).stream()).flatMap(it -> TypeCollector.inspect(it).list().stream()).forEach(types::add);
        if (!this.getIdentifyingAnnotations().isEmpty()) {
            Set<Class<?>> classes = this.aotContext.getTypeScanner().scanPackages(this.getBasePackages()).forTypesAnnotatedWith(this.getIdentifyingAnnotations()).collectAsSet();
            types.addAll(TypeCollector.inspect(classes).list());
        }
        return types;
    }
}

