/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.data.config.ConfigurationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public final class RepositoryFragmentConfiguration {
    private final String interfaceName;
    private final String className;
    private final Optional<AbstractBeanDefinition> beanDefinition;

    public RepositoryFragmentConfiguration(String interfaceName, String className) {
        Assert.hasText((String)interfaceName, (String)"Interface name must not be null or empty!");
        Assert.hasText((String)className, (String)"Class name must not be null or empty!");
        this.interfaceName = interfaceName;
        this.className = className;
        this.beanDefinition = Optional.empty();
    }

    public RepositoryFragmentConfiguration(String interfaceName, AbstractBeanDefinition beanDefinition) {
        Assert.hasText((String)interfaceName, (String)"Interface name must not be null or empty!");
        Assert.notNull((Object)beanDefinition, (String)"Bean definition must not be null!");
        this.interfaceName = interfaceName;
        this.className = ConfigurationUtils.getRequiredBeanClassName((BeanDefinition)beanDefinition);
        this.beanDefinition = Optional.of(beanDefinition);
    }

    public String getImplementationBeanName() {
        return StringUtils.uncapitalize((String)ClassUtils.getShortName((String)this.getClassName()));
    }

    public String getFragmentBeanName() {
        return this.getImplementationBeanName() + "Fragment";
    }

    @Generated
    public String getInterfaceName() {
        return this.interfaceName;
    }

    @Generated
    public String getClassName() {
        return this.className;
    }

    @Generated
    public Optional<AbstractBeanDefinition> getBeanDefinition() {
        return this.beanDefinition;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RepositoryFragmentConfiguration)) {
            return false;
        }
        RepositoryFragmentConfiguration other = (RepositoryFragmentConfiguration)o;
        String this$interfaceName = this.getInterfaceName();
        String other$interfaceName = other.getInterfaceName();
        if (this$interfaceName == null ? other$interfaceName != null : !this$interfaceName.equals(other$interfaceName)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        Optional<AbstractBeanDefinition> this$beanDefinition = this.getBeanDefinition();
        Optional<AbstractBeanDefinition> other$beanDefinition = other.getBeanDefinition();
        return !(this$beanDefinition == null ? other$beanDefinition != null : !((Object)this$beanDefinition).equals(other$beanDefinition));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $interfaceName = this.getInterfaceName();
        result = result * 59 + ($interfaceName == null ? 43 : $interfaceName.hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        Optional<AbstractBeanDefinition> $beanDefinition = this.getBeanDefinition();
        result = result * 59 + ($beanDefinition == null ? 43 : ((Object)$beanDefinition).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RepositoryFragmentConfiguration(interfaceName=" + this.getInterfaceName() + ", className=" + this.getClassName() + ", beanDefinition=" + this.getBeanDefinition() + ")";
    }
}

