/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.oss.driver.api.core.cql.Row;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.convert.CassandraValueProvider;
import org.springframework.data.cassandra.core.convert.RowReader;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.util.Assert;

public class RowValueProvider
implements CassandraValueProvider {
    private final RowReader reader;
    private final ValueExpressionEvaluator evaluator;

    public RowValueProvider(Row source, ValueExpressionEvaluator evaluator) {
        Assert.notNull((Object)source, (String)"Source Row must not be null");
        Assert.notNull((Object)evaluator, (String)"SpELExpressionEvaluator must not be null");
        this.reader = new RowReader(source);
        this.evaluator = evaluator;
    }

    public <T> @Nullable T getPropertyValue(CassandraPersistentProperty property) {
        String spelExpression = property.getSpelExpression();
        return (T)(spelExpression != null ? this.evaluator.evaluate(spelExpression) : this.reader.get(property.getRequiredColumnName()));
    }

    @Override
    public boolean hasProperty(CassandraPersistentProperty property) {
        Assert.notNull((Object)property, (String)"CassandraPersistentProperty must not be null");
        return this.reader.contains(property.getRequiredColumnName());
    }

    @Override
    public Object getSource() {
        return this.reader.getRow();
    }
}

