/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraParameters;
import org.springframework.data.cassandra.repository.query.ParameterBinding;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;

class BindingContext {
    private final CassandraParameters parameters;
    private final CassandraParameterAccessor parameterAccessor;
    private final List<ParameterBinding> bindings;
    private final ValueExpressionEvaluator evaluator;

    BindingContext(CassandraParameters parameters, CassandraParameterAccessor parameterAccessor, List<ParameterBinding> bindings, ValueExpressionEvaluator evaluator) {
        this.parameters = parameters;
        this.parameterAccessor = parameterAccessor;
        this.bindings = bindings;
        this.evaluator = evaluator;
    }

    private boolean hasBindings() {
        return !this.bindings.isEmpty();
    }

    public List<Object> getBindingValues() {
        if (!this.hasBindings()) {
            return Collections.emptyList();
        }
        ArrayList<Object> parameters = new ArrayList<Object>(this.bindings.size());
        for (ParameterBinding binding : this.bindings) {
            Object parameterValueForBinding = this.getParameterValueForBinding(binding);
            parameters.add(binding.prepareValue(parameterValueForBinding));
        }
        return parameters;
    }

    private @Nullable Object getParameterValueForBinding(ParameterBinding binding) {
        ParameterBinding.ParameterOrigin origin = binding.getOrigin();
        if (origin.isExpression() && origin instanceof ParameterBinding.Expression) {
            ParameterBinding.Expression expression = (ParameterBinding.Expression)origin;
            return this.evaluator.evaluate(expression.expression().getExpressionString());
        }
        if (origin instanceof ParameterBinding.MethodInvocationArgument) {
            ParameterBinding.MethodInvocationArgument invocationArgument = (ParameterBinding.MethodInvocationArgument)origin;
            ParameterBinding.BindingIdentifier argument = invocationArgument.identifier();
            return argument.hasName() ? this.parameterAccessor.getValue(this.getParameterIndex(this.parameters, argument.getName())) : this.parameterAccessor.getBindableValue(argument.getPosition());
        }
        throw new UnsupportedOperationException("Unsupported parameter origin '%s'".formatted(origin));
    }

    private int getParameterIndex(CassandraParameters parameters, String parameterName) {
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            CassandraParameters.CassandraParameter parameter = (CassandraParameters.CassandraParameter)((Object)iterator.next());
            if (!parameter.getName().filter(s -> s.equals(parameterName)).isPresent()) continue;
            return parameter.getIndex();
        }
        throw new IllegalArgumentException(String.format("Invalid parameter name; Cannot resolve parameter [%s]", parameterName));
    }
}

