/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.config;

import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.data.cassandra.repository.ReactiveCassandraRepository;
import org.springframework.data.cassandra.repository.config.CassandraRepositoryConfigurationExtension;
import org.springframework.data.cassandra.repository.support.ReactiveCassandraRepositoryFactoryBean;
import org.springframework.data.cassandra.repository.support.SimpleReactiveCassandraRepository;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.util.StringUtils;

public class ReactiveCassandraRepositoryConfigurationExtension
extends CassandraRepositoryConfigurationExtension {
    @Override
    public String getModuleName() {
        return "Reactive Cassandra";
    }

    @Override
    public String getRepositoryBaseClassName() {
        return SimpleReactiveCassandraRepository.class.getName();
    }

    @Override
    public String getRepositoryFactoryBeanClassName() {
        return ReactiveCassandraRepositoryFactoryBean.class.getName();
    }

    @Override
    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        String reactiveCassandraTemplateRef = config.getAttributes().getString("reactiveCassandraTemplateRef");
        if (StringUtils.hasText((String)reactiveCassandraTemplateRef)) {
            builder.addPropertyReference("reactiveCassandraOperations", reactiveCassandraTemplateRef);
        }
    }

    @Override
    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(ReactiveCassandraRepository.class);
    }

    @Override
    protected boolean useRepositoryConfiguration(RepositoryMetadata metadata) {
        return metadata.isReactiveRepository();
    }
}

