/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class PropertyMapping {
    private @Nullable String columnName;
    private String propertyName;

    public PropertyMapping(String propertyName) {
        Assert.notNull((Object)propertyName, (String)"Property name must not be null");
        this.propertyName = propertyName;
    }

    public PropertyMapping(String propertyName, String columnName) {
        Assert.notNull((Object)propertyName, (String)"Property name must not be null");
        this.propertyName = propertyName;
        this.setColumnName(columnName);
    }

    public @Nullable String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        Assert.notNull((Object)columnName, (String)"Column name must not be null");
        this.columnName = columnName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PropertyMapping)) {
            return false;
        }
        PropertyMapping that = (PropertyMapping)o;
        if (!ObjectUtils.nullSafeEquals((Object)this.columnName, (Object)that.columnName)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.propertyName, (Object)that.propertyName);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.columnName);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.propertyName);
        return result;
    }

    public String toString() {
        return String.format("{ @type = %1$s, propertyName = %2$s, columnName = %3$s }", this.getClass().getName(), this.getPropertyName(), this.getColumnName());
    }
}

