/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.data.CqlVector;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.mapping.CassandraType;
import org.springframework.data.mapping.model.SimpleTypeHolder;

public class CassandraSimpleTypeHolder
extends SimpleTypeHolder {
    public static final Set<Class<?>> CASSANDRA_SIMPLE_TYPES;
    private static final List<DataType> primitives;
    private static final Map<Class<?>, DataType> classToDataType;
    private static final Map<CassandraType.Name, DataType> nameToDataType;
    public static final SimpleTypeHolder HOLDER;

    private CassandraSimpleTypeHolder() {
        super(CASSANDRA_SIMPLE_TYPES, true);
    }

    private static Map<Class<?>, DataType> classToDataType(CodecRegistry codecRegistry, Map<Class<?>, Class<?>> primitiveWrappers) {
        HashMap classToDataType = new HashMap(16);
        primitives.forEach(dataType -> {
            Class javaType = codecRegistry.codecFor(dataType).getJavaType().getRawType();
            classToDataType.put(javaType, (DataType)dataType);
            Optional.ofNullable((Class)primitiveWrappers.get(javaType)).ifPresent(primitiveType -> classToDataType.put((Class<?>)primitiveType, (DataType)dataType));
        });
        classToDataType.put(Long.class, DataTypes.BIGINT);
        classToDataType.put(Long.TYPE, DataTypes.BIGINT);
        classToDataType.put(UUID.class, DataTypes.UUID);
        classToDataType.put(Date.class, DataTypes.TIMESTAMP);
        return classToDataType;
    }

    private static Map<CassandraType.Name, DataType> nameToDataType() {
        HashMap<CassandraType.Name, DataType> nameToDataType = new HashMap<CassandraType.Name, DataType>(16);
        nameToDataType.put(CassandraType.Name.ASCII, DataTypes.ASCII);
        nameToDataType.put(CassandraType.Name.BIGINT, DataTypes.BIGINT);
        nameToDataType.put(CassandraType.Name.BLOB, DataTypes.BLOB);
        nameToDataType.put(CassandraType.Name.BOOLEAN, DataTypes.BOOLEAN);
        nameToDataType.put(CassandraType.Name.COUNTER, DataTypes.COUNTER);
        nameToDataType.put(CassandraType.Name.DECIMAL, DataTypes.DECIMAL);
        nameToDataType.put(CassandraType.Name.DOUBLE, DataTypes.DOUBLE);
        nameToDataType.put(CassandraType.Name.FLOAT, DataTypes.FLOAT);
        nameToDataType.put(CassandraType.Name.INT, DataTypes.INT);
        nameToDataType.put(CassandraType.Name.TIMESTAMP, DataTypes.TIMESTAMP);
        nameToDataType.put(CassandraType.Name.UUID, DataTypes.UUID);
        nameToDataType.put(CassandraType.Name.VARCHAR, DataTypes.TEXT);
        nameToDataType.put(CassandraType.Name.TEXT, DataTypes.TEXT);
        nameToDataType.put(CassandraType.Name.TIMEUUID, DataTypes.TIMEUUID);
        nameToDataType.put(CassandraType.Name.INET, DataTypes.INET);
        nameToDataType.put(CassandraType.Name.DATE, DataTypes.DATE);
        nameToDataType.put(CassandraType.Name.SMALLINT, DataTypes.SMALLINT);
        nameToDataType.put(CassandraType.Name.TINYINT, DataTypes.TINYINT);
        nameToDataType.put(CassandraType.Name.VARINT, DataTypes.VARINT);
        nameToDataType.put(CassandraType.Name.TIME, DataTypes.TIME);
        nameToDataType.put(CassandraType.Name.DURATION, DataTypes.DURATION);
        return nameToDataType;
    }

    private static Set<Class<?>> getCassandraPrimitiveTypes(CodecRegistry codecRegistry) {
        return primitives.stream().map(arg_0 -> ((CodecRegistry)codecRegistry).codecFor(arg_0)).map(TypeCodec::getJavaType).map(GenericType::getRawType).collect(Collectors.toSet());
    }

    public static @Nullable DataType getDataTypeFor(Class<?> javaType) {
        return javaType.isEnum() ? DataTypes.TEXT : classToDataType.get(javaType);
    }

    public static DataType getRequiredDataTypeFor(Class<?> javaType) {
        DataType dataType = CassandraSimpleTypeHolder.getDataTypeFor(javaType);
        if (dataType == null) {
            throw new IllegalStateException(String.format("Required DataType cannot be resolved for %s", javaType.getName()));
        }
        return dataType;
    }

    public static @Nullable DataType getDataTypeFor(CassandraType.Name dataTypeName) {
        return nameToDataType.get((Object)dataTypeName);
    }

    public static DataType getRequiredDataTypeFor(CassandraType.Name dataTypeName) {
        DataType dataType = CassandraSimpleTypeHolder.getDataTypeFor(dataTypeName);
        if (dataType == null) {
            throw new IllegalStateException(String.format("Required DataType cannot be resolved for %s", new Object[]{dataTypeName}));
        }
        return dataType;
    }

    static {
        primitives = Arrays.asList(DataTypes.ASCII, DataTypes.BIGINT, DataTypes.BLOB, DataTypes.BOOLEAN, DataTypes.COUNTER, DataTypes.DECIMAL, DataTypes.DOUBLE, DataTypes.FLOAT, DataTypes.INT, DataTypes.TIMESTAMP, DataTypes.UUID, DataTypes.VARINT, DataTypes.TIMEUUID, DataTypes.INET, DataTypes.DATE, DataTypes.TEXT, DataTypes.TIME, DataTypes.SMALLINT, DataTypes.TINYINT, DataTypes.DURATION);
        CodecRegistry codecRegistry = CodecRegistry.DEFAULT;
        HashMap primitiveWrappers = new HashMap(8);
        primitiveWrappers.put(Boolean.class, Boolean.TYPE);
        primitiveWrappers.put(Byte.class, Byte.TYPE);
        primitiveWrappers.put(Character.class, Character.TYPE);
        primitiveWrappers.put(Double.class, Double.TYPE);
        primitiveWrappers.put(Float.class, Float.TYPE);
        primitiveWrappers.put(Integer.class, Integer.TYPE);
        primitiveWrappers.put(Long.class, Long.TYPE);
        primitiveWrappers.put(Short.class, Short.TYPE);
        Set<Class<?>> simpleTypes = CassandraSimpleTypeHolder.getCassandraPrimitiveTypes(codecRegistry);
        simpleTypes.add(Number.class);
        simpleTypes.add(Row.class);
        simpleTypes.add(TupleValue.class);
        simpleTypes.add(UdtValue.class);
        simpleTypes.add(CqlDuration.class);
        simpleTypes.add(CqlVector.class);
        classToDataType = Collections.unmodifiableMap(CassandraSimpleTypeHolder.classToDataType(codecRegistry, primitiveWrappers));
        nameToDataType = Collections.unmodifiableMap(CassandraSimpleTypeHolder.nameToDataType());
        CASSANDRA_SIMPLE_TYPES = Collections.unmodifiableSet(simpleTypes);
        HOLDER = new CassandraSimpleTypeHolder();
    }
}

