/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.cassandra.core.cql.Ordering;
import org.springframework.data.cassandra.core.mapping.Embedded;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.util.Assert;

public interface CassandraPersistentProperty
extends PersistentProperty<CassandraPersistentProperty>,
ApplicationContextAware {
    public void setColumnName(CqlIdentifier var1);

    public @Nullable CqlIdentifier getColumnName();

    default public CqlIdentifier getRequiredColumnName() {
        CqlIdentifier columnName = this.getColumnName();
        Assert.state((columnName != null ? 1 : 0) != 0, () -> String.format("No column name available for this persistent property [%1$s.%2$s]", this.getOwner().getName(), this.getName()));
        return columnName;
    }

    public boolean hasExplicitColumnName();

    public @Nullable Integer getOrdinal();

    default public int getRequiredOrdinal() {
        Integer ordinal = this.getOrdinal();
        Assert.state((ordinal != null ? 1 : 0) != 0, () -> String.format("No ordinal available for this persistent property [%1$s.%2$s]", this.getOwner().getName(), this.getName()));
        return ordinal;
    }

    default public boolean hasOrdinal() {
        return this.getOrdinal() != null;
    }

    public @Nullable Ordering getPrimaryKeyOrdering();

    public boolean isClusterKeyColumn();

    public boolean isCompositePrimaryKey();

    public boolean isMapLike();

    public boolean isPartitionKeyColumn();

    public boolean isPrimaryKeyColumn();

    public boolean isStaticColumn();

    default public boolean isEmbedded() {
        return this.findAnnotation(Embedded.class) != null && this.isEntity();
    }

    public @Nullable AnnotatedType findAnnotatedType(Class<? extends Annotation> var1);
}

