/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.cql.Ordering;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;

public class CachingCassandraPersistentProperty
extends BasicCassandraPersistentProperty {
    private final @Nullable Ordering primaryKeyOrdering;
    private final boolean isCompositePrimaryKey;
    private final boolean isClusterKeyColumn;
    private final boolean isPartitionKeyColumn;
    private final boolean isPrimaryKeyColumn;
    private final boolean isEmbedded;
    private final boolean isStaticColumn;
    private final Map<Class<? extends Annotation>, Optional<AnnotatedType>> findAnnotatedTypeCache = new ConcurrentHashMap<Class<? extends Annotation>, Optional<AnnotatedType>>();

    public CachingCassandraPersistentProperty(Property property, CassandraPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        super(property, owner, simpleTypeHolder);
        this.primaryKeyOrdering = super.getPrimaryKeyOrdering();
        this.isCompositePrimaryKey = super.isCompositePrimaryKey();
        this.isClusterKeyColumn = super.isClusterKeyColumn();
        this.isPartitionKeyColumn = super.isPartitionKeyColumn();
        this.isPrimaryKeyColumn = super.isPrimaryKeyColumn();
        this.isEmbedded = super.isEmbedded();
        this.isStaticColumn = super.isStaticColumn();
    }

    @Override
    public @Nullable Ordering getPrimaryKeyOrdering() {
        return this.primaryKeyOrdering;
    }

    @Override
    public boolean isCompositePrimaryKey() {
        return this.isCompositePrimaryKey;
    }

    @Override
    public boolean isClusterKeyColumn() {
        return this.isClusterKeyColumn;
    }

    @Override
    public boolean isPartitionKeyColumn() {
        return this.isPartitionKeyColumn;
    }

    @Override
    public boolean isPrimaryKeyColumn() {
        return this.isPrimaryKeyColumn;
    }

    @Override
    public boolean isStaticColumn() {
        return this.isStaticColumn;
    }

    @Override
    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    @Override
    public @Nullable AnnotatedType findAnnotatedType(Class<? extends Annotation> annotationType) {
        return this.findAnnotatedTypeCache.computeIfAbsent(annotationType, key -> Optional.ofNullable(super.findAnnotatedType((Class<? extends Annotation>)key))).orElse(null);
    }
}

