/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.keyspace;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.cql.keyspace.AddColumnSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.AlterColumnSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.AlterKeyspaceSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.AlterTableSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.AlterUserTypeSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CreateIndexSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CreateKeyspaceSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CreateTableSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CreateUserTypeSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.DropColumnSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.DropIndexSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.DropKeyspaceSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.DropTableSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.DropUserTypeSpecification;
import org.springframework.util.ObjectUtils;

public final class SpecificationBuilder {
    private SpecificationBuilder() {
    }

    public static CreateKeyspaceSpecification createKeyspace(String name) {
        return CreateKeyspaceSpecification.createKeyspace(name);
    }

    public static CreateKeyspaceSpecification createKeyspace(CqlIdentifier name) {
        return CreateKeyspaceSpecification.createKeyspace(name);
    }

    public static AlterKeyspaceSpecification alterKeyspace(String name) {
        return AlterKeyspaceSpecification.alterKeyspace(name);
    }

    public static AlterKeyspaceSpecification alterKeyspace(CqlIdentifier name) {
        return AlterKeyspaceSpecification.alterKeyspace(name);
    }

    public static DropKeyspaceSpecification dropKeyspace(String name) {
        return DropKeyspaceSpecification.dropKeyspace(name);
    }

    public static DropKeyspaceSpecification dropKeyspace(CqlIdentifier name) {
        return DropKeyspaceSpecification.dropKeyspace(name);
    }

    public static CreateTableSpecification createTable(String tableName) {
        return CreateTableSpecification.createTable(tableName);
    }

    public static CreateTableSpecification createTable(@Nullable String keyspace, String tableName) {
        return SpecificationBuilder.createTable(SpecificationBuilder.getOptionalKeyspace(keyspace), CqlIdentifier.fromCql((String)tableName));
    }

    public static CreateTableSpecification createTable(CqlIdentifier tableName) {
        return CreateTableSpecification.createTable(tableName);
    }

    public static CreateTableSpecification createTable(@Nullable CqlIdentifier keyspace, CqlIdentifier tableName) {
        return CreateTableSpecification.createTable(keyspace, tableName);
    }

    public static AlterTableSpecification alterTable(String tableName) {
        return AlterTableSpecification.alterTable(tableName);
    }

    public static AlterTableSpecification alterTable(@Nullable String keyspace, String tableName) {
        return SpecificationBuilder.alterTable(SpecificationBuilder.getOptionalKeyspace(keyspace), CqlIdentifier.fromCql((String)tableName));
    }

    public static AlterTableSpecification alterTable(CqlIdentifier tableName) {
        return AlterTableSpecification.alterTable(null, tableName);
    }

    public static AlterTableSpecification alterTable(@Nullable CqlIdentifier keyspace, CqlIdentifier tableName) {
        return AlterTableSpecification.alterTable(keyspace, tableName);
    }

    public static DropTableSpecification dropTable(String tableName) {
        return DropTableSpecification.dropTable(tableName);
    }

    public static DropTableSpecification dropTable(@Nullable String keyspace, String tableName) {
        return SpecificationBuilder.dropTable(SpecificationBuilder.getOptionalKeyspace(keyspace), CqlIdentifier.fromCql((String)tableName));
    }

    public static DropTableSpecification dropTable(CqlIdentifier tableName) {
        return DropTableSpecification.dropTable(tableName);
    }

    public static DropTableSpecification dropTable(@Nullable CqlIdentifier keyspace, CqlIdentifier tableName) {
        return DropTableSpecification.dropTable(keyspace, tableName);
    }

    public static AddColumnSpecification addColumn(String name, DataType type) {
        return AddColumnSpecification.addColumn(name, type);
    }

    public static AddColumnSpecification addColumn(CqlIdentifier name, DataType type) {
        return AddColumnSpecification.addColumn(name, type);
    }

    public static AlterColumnSpecification alterColumn(String name, DataType type) {
        return AlterColumnSpecification.alterColumn(name, type);
    }

    public static AlterColumnSpecification alterColumn(CqlIdentifier name, DataType type) {
        return AlterColumnSpecification.alterColumn(name, type);
    }

    public static DropColumnSpecification dropColumn(String name) {
        return DropColumnSpecification.dropColumn(name);
    }

    public static DropColumnSpecification dropColumn(CqlIdentifier name) {
        return DropColumnSpecification.dropColumn(name);
    }

    public static CreateIndexSpecification createIndex() {
        return CreateIndexSpecification.createIndex();
    }

    public static CreateIndexSpecification createIndex(String indexName) {
        return CreateIndexSpecification.createIndex(indexName);
    }

    public static CreateIndexSpecification createIndex(@Nullable String keyspace, String indexName) {
        return SpecificationBuilder.createIndex(SpecificationBuilder.getOptionalKeyspace(keyspace), CqlIdentifier.fromCql((String)indexName));
    }

    public static CreateIndexSpecification createIndex(CqlIdentifier indexName) {
        return CreateIndexSpecification.createIndex(null, indexName);
    }

    public static CreateIndexSpecification createIndex(@Nullable CqlIdentifier keyspace, @Nullable CqlIdentifier indexName) {
        return CreateIndexSpecification.createIndex(keyspace, indexName);
    }

    public static DropIndexSpecification dropIndex(String indexName) {
        return DropIndexSpecification.dropIndex(indexName);
    }

    public static DropIndexSpecification dropIndex(@Nullable String keyspace, String indexName) {
        return SpecificationBuilder.dropIndex(SpecificationBuilder.getOptionalKeyspace(keyspace), CqlIdentifier.fromCql((String)indexName));
    }

    public static DropIndexSpecification dropIndex(CqlIdentifier indexName) {
        return DropIndexSpecification.dropIndex(null, indexName);
    }

    public static DropIndexSpecification dropIndex(@Nullable CqlIdentifier keyspace, CqlIdentifier indexName) {
        return DropIndexSpecification.dropIndex(keyspace, indexName);
    }

    public static CreateUserTypeSpecification createType(String typeName) {
        return CreateUserTypeSpecification.createType(typeName);
    }

    public static CreateUserTypeSpecification createType(@Nullable String keyspace, String typeName) {
        return SpecificationBuilder.createType(SpecificationBuilder.getOptionalKeyspace(keyspace), CqlIdentifier.fromCql((String)typeName));
    }

    public static CreateUserTypeSpecification createType(CqlIdentifier name) {
        return CreateUserTypeSpecification.createType(name);
    }

    public static CreateUserTypeSpecification createType(@Nullable CqlIdentifier keyspace, CqlIdentifier name) {
        return CreateUserTypeSpecification.createType(keyspace, name);
    }

    public static AlterUserTypeSpecification alterType(String typeName) {
        return AlterUserTypeSpecification.alterType(typeName);
    }

    private static AlterUserTypeSpecification alterType(@Nullable String keyspace, String typeName) {
        return SpecificationBuilder.alterType(SpecificationBuilder.getOptionalKeyspace(keyspace), CqlIdentifier.fromCql((String)typeName));
    }

    private static AlterUserTypeSpecification alterType(CqlIdentifier typeName) {
        return AlterUserTypeSpecification.alterType(typeName);
    }

    private static AlterUserTypeSpecification alterType(@Nullable CqlIdentifier keyspace, CqlIdentifier typeName) {
        return AlterUserTypeSpecification.alterType(keyspace, typeName);
    }

    public static DropUserTypeSpecification dropType(String typeName) {
        return DropUserTypeSpecification.dropType(typeName);
    }

    public static DropUserTypeSpecification dropType(@Nullable String keyspace, String typeName) {
        return SpecificationBuilder.dropType(SpecificationBuilder.getOptionalKeyspace(keyspace), CqlIdentifier.fromCql((String)typeName));
    }

    public static DropUserTypeSpecification dropType(CqlIdentifier typeName) {
        return DropUserTypeSpecification.dropType(typeName);
    }

    public static DropUserTypeSpecification dropType(@Nullable CqlIdentifier keyspace, CqlIdentifier typeName) {
        return DropUserTypeSpecification.dropType(keyspace, typeName);
    }

    private static @Nullable CqlIdentifier getOptionalKeyspace(@Nullable String keyspace) {
        return ObjectUtils.isEmpty((Object)keyspace) ? null : CqlIdentifier.fromCql((String)keyspace);
    }
}

