/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.aot;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.repository.query.CassandraParameters;
import org.springframework.data.domain.Limit;
import org.springframework.data.domain.Slice;
import org.springframework.data.expression.ValueEvaluationContextProvider;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersSource;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.util.Lazy;
import org.springframework.util.ConcurrentLruCache;

public class AotRepositoryFragmentSupport {
    private static final ConversionService CONVERSION_SERVICE;
    private final RepositoryMetadata repositoryMetadata;
    private final CassandraOperations cassandraOperations;
    private final CassandraConverter converter;
    private final ProjectionFactory projectionFactory;
    private final Lazy<ConcurrentLruCache<String, ValueExpression>> expressions;
    private final Lazy<ConcurrentLruCache<Method, ValueEvaluationContextProvider>> contextProviders;

    protected AotRepositoryFragmentSupport(CassandraOperations cassandraOperations, RepositoryFactoryBeanSupport.FragmentCreationContext context) {
        this(cassandraOperations, context.getRepositoryMetadata(), context.getValueExpressionDelegate(), context.getProjectionFactory());
    }

    protected AotRepositoryFragmentSupport(CassandraOperations cassandraOperations, RepositoryMetadata repositoryMetadata, ValueExpressionDelegate valueExpressions, ProjectionFactory projectionFactory) {
        this.cassandraOperations = cassandraOperations;
        this.converter = cassandraOperations.getConverter();
        this.repositoryMetadata = repositoryMetadata;
        this.projectionFactory = projectionFactory;
        this.expressions = Lazy.of(() -> new ConcurrentLruCache(32, arg_0 -> ((ValueExpressionDelegate)valueExpressions).parse(arg_0)));
        this.contextProviders = Lazy.of(() -> new ConcurrentLruCache(32, it -> valueExpressions.createValueContextProvider((Parameters)new CassandraParameters(ParametersSource.of((RepositoryMetadata)repositoryMetadata, (Method)it)))));
    }

    protected @Nullable Object potentiallyConvertBindingValue(@Nullable Object bindableValue) {
        if (bindableValue == null) {
            return null;
        }
        if (bindableValue instanceof Limit) {
            Limit limit = (Limit)bindableValue;
            return limit.max();
        }
        return this.converter.convertToColumnType(bindableValue, this.converter.getColumnTypeResolver().resolve(bindableValue));
    }

    protected @Nullable Object evaluateExpression(Method method, String expressionString, Object ... args) {
        ValueExpression expression = (ValueExpression)((ConcurrentLruCache)this.expressions.get()).get((Object)expressionString);
        ValueEvaluationContextProvider contextProvider = (ValueEvaluationContextProvider)((ConcurrentLruCache)this.contextProviders.get()).get((Object)method);
        return this.potentiallyConvertBindingValue(expression.evaluate(contextProvider.getEvaluationContext((Object)args, expression.getExpressionDependencies())));
    }

    protected <T> @Nullable T convertOne(@Nullable Object result, Class<T> projection) {
        if (result == null) {
            return null;
        }
        if (projection.isInstance(result)) {
            return projection.cast(result);
        }
        if (CONVERSION_SERVICE.canConvert(result.getClass(), projection)) {
            return (T)CONVERSION_SERVICE.convert(result, projection);
        }
        return (T)this.projectionFactory.createProjection(projection, result);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @Nullable Object convertMany(@Nullable Object result, Class<?> projection) {
        if (result == null) {
            return null;
        }
        if (projection.isInstance(result)) {
            return result;
        }
        if (result instanceof Stream) {
            Stream stream = (Stream)result;
            return stream.map(it -> this.convertOne(it, projection));
        }
        if (result instanceof Slice) {
            Slice slice = (Slice)result;
            return slice.map(it -> this.convertOne(it, projection));
        }
        if (result instanceof Collection) {
            Collection collection = (Collection)result;
            @Nullable Collection target = CollectionFactory.createCollection(collection.getClass(), (int)collection.size());
            for (Object o : collection) {
                target.add(this.convertOne(o, projection));
            }
            return target;
        }
        throw new UnsupportedOperationException("Cannot create projection for %s".formatted(result));
    }

    static {
        DefaultConversionService conversionService = new DefaultConversionService();
        conversionService.removeConvertible(Collection.class, Object.class);
        conversionService.removeConvertible(Object.class, Optional.class);
        CONVERSION_SERVICE = conversionService;
    }
}

