/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.oss.driver.api.core.data.UdtValue;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.convert.CassandraValueProvider;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.util.Assert;

public class UdtValueProvider
implements CassandraValueProvider {
    private final UdtValue udtValue;
    private final ValueExpressionEvaluator evaluator;

    public UdtValueProvider(UdtValue udtValue, ValueExpressionEvaluator evaluator) {
        Assert.notNull((Object)udtValue, (String)"UDTValue must not be null");
        Assert.notNull((Object)evaluator, (String)"SpELExpressionEvaluator must not be null");
        this.udtValue = udtValue;
        this.evaluator = evaluator;
    }

    public <T> @Nullable T getPropertyValue(CassandraPersistentProperty property) {
        String spelExpression = property.getSpelExpression();
        if (spelExpression != null) {
            return (T)this.evaluator.evaluate(spelExpression);
        }
        return (T)this.udtValue.getObject(property.getRequiredColumnName());
    }

    @Override
    public boolean hasProperty(CassandraPersistentProperty property) {
        return this.udtValue.getType().contains(property.getRequiredColumnName());
    }

    @Override
    public Object getSource() {
        return this.udtValue;
    }
}

