/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.data.cassandra.ReactiveSession;
import org.springframework.data.cassandra.ReactiveSessionFactory;
import org.springframework.data.cassandra.config.AbstractCassandraConfiguration;
import org.springframework.data.cassandra.core.ReactiveCassandraTemplate;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.cql.ReactiveCqlTemplate;
import org.springframework.data.cassandra.core.cql.session.DefaultBridgedReactiveSession;
import org.springframework.data.cassandra.core.cql.session.DefaultReactiveSessionFactory;

public abstract class AbstractReactiveCassandraConfiguration
extends AbstractCassandraConfiguration {
    private @Nullable BeanFactory beanFactory;

    @Bean
    public ReactiveSession reactiveCassandraSession() {
        return new DefaultBridgedReactiveSession(this.getRequiredSession());
    }

    @Bean
    public ReactiveSessionFactory reactiveCassandraSessionFactory() {
        return new DefaultReactiveSessionFactory(this.getBean(ReactiveSession.class));
    }

    @Bean
    public ReactiveCassandraTemplate reactiveCassandraTemplate() {
        return new ReactiveCassandraTemplate(this.getBean(ReactiveSessionFactory.class), this.getBean(CassandraConverter.class));
    }

    @Bean
    public ReactiveCqlTemplate reactiveCqlTemplate() {
        return new ReactiveCqlTemplate(this.getBean(ReactiveSessionFactory.class));
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        super.setBeanFactory(beanFactory);
    }

    private <T> T getBean(Class<T> requiredType) {
        if (this.beanFactory == null) {
            throw new IllegalStateException("BeanFactory must not be null");
        }
        return (T)this.beanFactory.getBean(requiredType);
    }
}

