/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraParameters;
import org.springframework.data.domain.Limit;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.util.Assert;

class BindingContext {
    private final CassandraParameters parameters;
    private final CassandraParameterAccessor parameterAccessor;
    private final List<ParameterBinding> bindings;
    private final ValueExpressionEvaluator evaluator;

    BindingContext(CassandraParameters parameters, CassandraParameterAccessor parameterAccessor, List<ParameterBinding> bindings, ValueExpressionEvaluator evaluator) {
        this.parameters = parameters;
        this.parameterAccessor = parameterAccessor;
        this.bindings = bindings;
        this.evaluator = evaluator;
    }

    private boolean hasBindings() {
        return !this.bindings.isEmpty();
    }

    public List<Object> getBindingValues() {
        if (!this.hasBindings()) {
            return Collections.emptyList();
        }
        ArrayList<Object> parameters = new ArrayList<Object>(this.bindings.size());
        for (ParameterBinding binding : this.bindings) {
            Object parameterValueForBinding = this.getParameterValueForBinding(binding);
            parameters.add(binding.prepareValue(parameterValueForBinding));
        }
        return parameters;
    }

    private @Nullable Object getParameterValueForBinding(ParameterBinding binding) {
        if (binding.isExpression()) {
            return this.evaluator.evaluate(binding.getRequiredExpression());
        }
        return binding.isNamed() ? this.parameterAccessor.getValue(this.getParameterIndex(this.parameters, binding.getRequiredParameterName())) : this.parameterAccessor.getBindableValue(binding.getParameterIndex());
    }

    private int getParameterIndex(CassandraParameters parameters, String parameterName) {
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            CassandraParameters.CassandraParameter parameter = (CassandraParameters.CassandraParameter)((Object)iterator.next());
            if (!parameter.getName().filter(s -> s.equals(parameterName)).isPresent()) continue;
            return parameter.getIndex();
        }
        throw new IllegalArgumentException(String.format("Invalid parameter name; Cannot resolve parameter [%s]", parameterName));
    }

    static class ParameterBinding {
        private final int parameterIndex;
        private final @Nullable String expression;
        private final @Nullable String parameterName;

        private ParameterBinding(int parameterIndex, @Nullable String expression, @Nullable String parameterName) {
            this.parameterIndex = parameterIndex;
            this.expression = expression;
            this.parameterName = parameterName;
        }

        public static ParameterBinding expression(String expression, boolean quoted) {
            return new ParameterBinding(-1, expression, null);
        }

        public static ParameterBinding indexed(int parameterIndex) {
            return new ParameterBinding(parameterIndex, null, null);
        }

        public static ParameterBinding named(String name) {
            return new ParameterBinding(-1, null, name);
        }

        public boolean isNamed() {
            return this.parameterName != null;
        }

        public int getParameterIndex() {
            return this.parameterIndex;
        }

        public String getParameter() {
            return "?" + (this.isExpression() ? "expr" : "") + this.parameterIndex;
        }

        public String getRequiredExpression() {
            Assert.state((this.expression != null ? 1 : 0) != 0, (String)"ParameterBinding is not an expression");
            return this.expression;
        }

        boolean isExpression() {
            return this.expression != null;
        }

        String getRequiredParameterName() {
            Assert.state((this.parameterName != null ? 1 : 0) != 0, (String)"ParameterBinding is not named");
            return this.parameterName;
        }

        public @Nullable Object prepareValue(@Nullable Object value) {
            if (value == null) {
                return value;
            }
            if (value instanceof Limit) {
                Limit limit = (Limit)value;
                return limit.max();
            }
            return value;
        }
    }
}

