/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.util.Predicates;

public class PersistentPropertyTranslator {
    public CassandraPersistentProperty translate(CassandraPersistentProperty property) {
        return property;
    }

    public static PersistentPropertyTranslator create(@Nullable CassandraPersistentEntity<?> targetEntity) {
        return PersistentPropertyTranslator.create(targetEntity, Predicates.isTrue());
    }

    public static PersistentPropertyTranslator create(@Nullable CassandraPersistentEntity<?> targetEntity, Predicate<CassandraPersistentProperty> translationFilter) {
        return targetEntity != null ? new EntityPropertyTranslator(targetEntity, translationFilter) : new PersistentPropertyTranslator();
    }

    private static class EntityPropertyTranslator
    extends PersistentPropertyTranslator {
        private final CassandraPersistentEntity<?> targetEntity;
        private final Predicate<CassandraPersistentProperty> translationFilter;

        EntityPropertyTranslator(CassandraPersistentEntity<?> targetEntity, Predicate<CassandraPersistentProperty> translationFilter) {
            this.targetEntity = targetEntity;
            this.translationFilter = translationFilter;
        }

        @Override
        public CassandraPersistentProperty translate(CassandraPersistentProperty property) {
            if (!this.translationFilter.test(property)) {
                return property;
            }
            CassandraPersistentProperty targetProperty = (CassandraPersistentProperty)this.targetEntity.getPersistentProperty(property.getName());
            return targetProperty != null ? targetProperty : property;
        }
    }
}

