/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.data.cassandra.core.cql.Ordering;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.Parameter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.util.TypeInformation;

class CassandraConstructorProperty
implements CassandraPersistentProperty {
    private final Parameter<?, CassandraPersistentProperty> constructorParameter;
    private final String name;
    private final CassandraPersistentEntity<?> owner;
    private final TypeInformation<?> typeInformation;

    public CassandraConstructorProperty(Parameter<?, CassandraPersistentProperty> constructorParameter, CassandraPersistentEntity<?> owner) {
        this.constructorParameter = constructorParameter;
        String name = constructorParameter.getName();
        if (name == null) {
            throw new IllegalArgumentException(String.format("Constructor parameter %s must have a name", constructorParameter));
        }
        this.name = name;
        this.owner = owner;
        this.typeInformation = constructorParameter.getType();
    }

    @Override
    public CqlIdentifier getColumnName() {
        throw new IllegalStateException(String.format("Parameter %s is not annotated with @Column", this.name));
    }

    @Override
    public @Nullable Integer getOrdinal() {
        throw new IllegalStateException(String.format("Parameter %s is not annotated with @Element", this.name));
    }

    @Override
    public @Nullable Ordering getPrimaryKeyOrdering() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClusterKeyColumn() {
        return false;
    }

    @Override
    public boolean isCompositePrimaryKey() {
        return false;
    }

    @Override
    public boolean isMapLike() {
        return this.typeInformation.isMap();
    }

    @Override
    public boolean isPartitionKeyColumn() {
        return false;
    }

    @Override
    public boolean isPrimaryKeyColumn() {
        return false;
    }

    @Override
    public boolean isStaticColumn() {
        return false;
    }

    @Override
    public @Nullable AnnotatedType findAnnotatedType(Class<? extends Annotation> annotationType) {
        return null;
    }

    public PersistentEntity<?, CassandraPersistentProperty> getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasExplicitColumnName() {
        return false;
    }

    public Class<?> getType() {
        return this.constructorParameter.getRawType();
    }

    public TypeInformation<?> getTypeInformation() {
        return this.typeInformation;
    }

    public @Nullable Method getGetter() {
        return null;
    }

    public @Nullable Method getSetter() {
        return null;
    }

    public @Nullable Method getWither() {
        return null;
    }

    public @Nullable Field getField() {
        return null;
    }

    public @Nullable String getSpelExpression() {
        return null;
    }

    public @Nullable Association<CassandraPersistentProperty> getAssociation() {
        return null;
    }

    public boolean isEntity() {
        return false;
    }

    public boolean isIdProperty() {
        return false;
    }

    public boolean isVersionProperty() {
        return false;
    }

    public boolean isCollectionLike() {
        return this.typeInformation.isCollectionLike();
    }

    public boolean isMap() {
        return this.typeInformation.isMap();
    }

    public boolean isArray() {
        return this.typeInformation.getType().isArray();
    }

    public boolean isTransient() {
        return false;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isImmutable() {
        return false;
    }

    public boolean isAssociation() {
        return false;
    }

    public @Nullable Class<?> getComponentType() {
        return Optional.ofNullable(this.typeInformation.getComponentType()).map(TypeInformation::getType).orElse(null);
    }

    public Class<?> getRawType() {
        return this.typeInformation.getType();
    }

    public @Nullable Class<?> getMapValueType() {
        return Optional.ofNullable(this.typeInformation.getMapValueType()).map(TypeInformation::getType).orElse(null);
    }

    public Class<?> getActualType() {
        return this.typeInformation.getRequiredActualType().getType();
    }

    public <A extends Annotation> @Nullable A findAnnotation(Class<A> annotationType) {
        return null;
    }

    public <A extends Annotation> @Nullable A findPropertyOrOwnerAnnotation(Class<A> annotationType) {
        return null;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return false;
    }

    public boolean usePropertyAccess() {
        return false;
    }

    public @Nullable Class<?> getAssociationTargetType() {
        return null;
    }

    public Iterable<? extends TypeInformation<?>> getPersistentEntityTypeInformation() {
        return Collections.emptyList();
    }

    public @Nullable TypeInformation<?> getAssociationTargetTypeInformation() {
        return null;
    }

    @Override
    public void setColumnName(CqlIdentifier columnName) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setForceQuote(boolean forceQuote) {
        throw new UnsupportedOperationException();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CassandraConstructorProperty)) {
            return false;
        }
        CassandraConstructorProperty that = (CassandraConstructorProperty)o;
        return this.constructorParameter.equals(that.constructorParameter);
    }

    public int hashCode() {
        return this.constructorParameter.hashCode();
    }
}

