/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.core.EntityWriteResult;
import org.springframework.data.cassandra.core.ExecutableInsertOperation;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.util.Assert;

class ExecutableInsertOperationSupport
implements ExecutableInsertOperation {
    private final CassandraTemplate template;

    ExecutableInsertOperationSupport(CassandraTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ExecutableInsertOperation.ExecutableInsert<T> insert(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ExecutableInsertSupport<T>(this.template, domainType, InsertOptions.empty(), null);
    }

    static class ExecutableInsertSupport<T>
    implements ExecutableInsertOperation.ExecutableInsert<T> {
        private final CassandraTemplate template;
        private final Class<T> domainType;
        private final InsertOptions insertOptions;
        private final @Nullable CqlIdentifier tableName;

        public ExecutableInsertSupport(CassandraTemplate template, Class<T> domainType, InsertOptions insertOptions, @Nullable CqlIdentifier tableName) {
            this.template = template;
            this.domainType = domainType;
            this.insertOptions = insertOptions;
            this.tableName = tableName;
        }

        @Override
        public ExecutableInsertOperation.InsertWithOptions<T> inTable(CqlIdentifier tableName) {
            Assert.notNull((Object)tableName, (String)"Table name must not be null");
            return new ExecutableInsertSupport<T>(this.template, this.domainType, this.insertOptions, tableName);
        }

        @Override
        public ExecutableInsertOperation.TerminatingInsert<T> withOptions(InsertOptions insertOptions) {
            Assert.notNull((Object)insertOptions, (String)"InsertOptions must not be null");
            return new ExecutableInsertSupport<T>(this.template, this.domainType, insertOptions, this.tableName);
        }

        @Override
        public EntityWriteResult<T> one(T object) {
            Assert.notNull(object, (String)"Object must not be null");
            return this.template.doInsert(object, this.insertOptions, this.getTableName());
        }

        private CqlIdentifier getTableName() {
            return this.tableName != null ? this.tableName : this.template.getTableName(this.domainType);
        }
    }
}

