/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.generator;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.cql.keyspace.TableNameSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.UserTypeNameSpecification;

class CqlIdentifierUtil {
    CqlIdentifierUtil() {
    }

    public static String renderName(UserTypeNameSpecification spec) {
        return CqlIdentifierUtil.renderName(spec.getKeyspace(), spec.getName());
    }

    public static String renderName(TableNameSpecification spec) {
        return CqlIdentifierUtil.renderName(spec.getKeyspace(), spec.getName());
    }

    public static String renderName(@Nullable CqlIdentifier keyspace, CqlIdentifier name) {
        if (keyspace != null) {
            return String.format("%s.%s", keyspace.asCql(true), name.asCql(true));
        }
        return name.asCql(true);
    }
}

