/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.converter;

import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.Row;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;

@ReadingConverter
public enum RowToMapConverter implements Converter<Row, Map<String, Object>>
{
    INSTANCE;


    public Map<String, @Nullable Object> convert(Row row) {
        ColumnDefinitions cols = row.getColumnDefinitions();
        HashMap<String, @Nullable Object> map = new HashMap<String, Object>(cols.size());
        cols.forEach(columnDefinition -> map.put(columnDefinition.getName().toString(), row.isNull(columnDefinition.getName()) ? null : row.getObject(columnDefinition.getName())));
        return map;
    }
}

