/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.CodecNotFoundException;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.core.convert.CassandraColumnType;
import org.springframework.data.cassandra.core.convert.ColumnType;
import org.springframework.data.cassandra.core.convert.ColumnTypeResolver;
import org.springframework.data.cassandra.core.convert.DefaultCassandraColumnType;
import org.springframework.data.cassandra.core.convert.DefaultColumnType;
import org.springframework.data.cassandra.core.convert.FrozenIndicator;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.CassandraSimpleTypeHolder;
import org.springframework.data.cassandra.core.mapping.CassandraType;
import org.springframework.data.cassandra.core.mapping.Frozen;
import org.springframework.data.cassandra.core.mapping.UserTypeResolver;
import org.springframework.data.cassandra.core.mapping.VectorType;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.PropertyValueConversions;
import org.springframework.data.convert.PropertyValueConverter;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class DefaultColumnTypeResolver
implements ColumnTypeResolver {
    private final Log log = LogFactory.getLog(this.getClass());
    private final MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty> mappingContext;
    private final UserTypeResolver userTypeResolver;
    private final Supplier<CodecRegistry> codecRegistry;
    private final Supplier<CustomConversions> customConversions;
    private final Map<CassandraPersistentProperty, CassandraColumnType> columnTypeCache = new ConcurrentHashMap<CassandraPersistentProperty, CassandraColumnType>();
    private final Map<TypeInformation<?>, CassandraColumnType> typeInformationColumnTypeCache = new ConcurrentHashMap();

    public DefaultColumnTypeResolver(MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty> mappingContext, UserTypeResolver userTypeResolver, Supplier<CodecRegistry> codecRegistry, Supplier<CustomConversions> customConversions) {
        this.mappingContext = mappingContext;
        this.userTypeResolver = userTypeResolver;
        this.codecRegistry = codecRegistry;
        this.customConversions = customConversions;
    }

    @Override
    public CassandraColumnType resolve(CassandraPersistentProperty property) {
        Assert.notNull((Object)property, (String)"Property must not be null");
        CassandraColumnType cassandraColumnType = this.columnTypeCache.get(property);
        if (cassandraColumnType == null) {
            cassandraColumnType = this.doResolve(property);
            this.columnTypeCache.put(property, cassandraColumnType);
        }
        return cassandraColumnType;
    }

    private CassandraColumnType doResolve(CassandraPersistentProperty property) {
        if (property.isAnnotationPresent(CassandraType.class)) {
            CassandraType annotation = (CassandraType)property.getRequiredAnnotation(CassandraType.class);
            if (annotation.type() == CassandraType.Name.UDT && ObjectUtils.isEmpty((Object)annotation.userTypeName())) {
                throw new InvalidDataAccessApiUsageException(String.format("Expected user type name in property ['%s'] of type ['%s'] in entity [%s]", property.getName(), property.getType(), property.getOwner().getName()));
            }
            if ((annotation.type() == CassandraType.Name.LIST || annotation.type() == CassandraType.Name.SET) && annotation.typeArguments().length != 1) {
                throw new InvalidDataAccessApiUsageException(String.format("Expected [%d] type arguments for property ['%s'] of type ['%s'] in entity [%s]; actual was [%d]", 1, property.getName(), property.getType(), property.getOwner().getName(), annotation.typeArguments().length));
            }
            if (annotation.type() == CassandraType.Name.MAP && annotation.typeArguments().length != 2) {
                throw new InvalidDataAccessApiUsageException(String.format("Expected [%d] type arguments for property ['%s'] of type ['%s'] in entity [%s]; actual was [%d]", 2, property.getName(), property.getType(), property.getOwner().getName(), annotation.typeArguments().length));
            }
            if (annotation.type() == CassandraType.Name.VECTOR) {
                return this.resolve((VectorType)property.getRequiredAnnotation(VectorType.class));
            }
            return this.resolve(annotation);
        }
        PropertyValueConversions pvc = this.customConversions.get().getPropertyValueConversions();
        TypeInformation typeInformation = property.getTypeInformation();
        if (pvc != null && pvc.hasValueConverter((PersistentProperty)property)) {
            PropertyValueConverter converter = pvc.getValueConverter((PersistentProperty)property);
            ResolvableType resolvableType = ResolvableType.forClass(converter.getClass());
            ResolvableType storeType = resolvableType.as(PropertyValueConverter.class).getGeneric(new int[]{1});
            Class storeTypeClass = storeType.resolve();
            if (storeTypeClass == Object.class || storeTypeClass == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("PropertyValueConverter %s for Property %s.%s resolves to Object.class. Falling back to the property type %s.", converter, property.getOwner().getName(), property.getName(), typeInformation));
                }
            } else {
                typeInformation = TypeInformation.of((ResolvableType)storeType);
            }
        }
        return this.resolve(typeInformation, this.getFrozenInfo(property));
    }

    private FrozenIndicator getFrozenInfo(CassandraPersistentProperty property) {
        AnnotatedType annotatedType = property.findAnnotatedType(Frozen.class);
        if (annotatedType == null) {
            return FrozenIndicator.NOT_FROZEN;
        }
        return this.getFrozenIndicator(annotatedType);
    }

    private FrozenIndicator getFrozenIndicator(AnnotatedType annotatedType) {
        FrozenIndicator frozen = FrozenIndicator.frozen(this.isFrozen(annotatedType));
        if (annotatedType instanceof AnnotatedParameterizedType) {
            AnnotatedType[] annotatedTypes;
            AnnotatedParameterizedType apt = (AnnotatedParameterizedType)annotatedType;
            for (AnnotatedType type : annotatedTypes = apt.getAnnotatedActualTypeArguments()) {
                frozen.addNested(this.getFrozenIndicator(type));
            }
        }
        return frozen;
    }

    private boolean isFrozen(AnnotatedType type) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)type, Frozen.class);
    }

    @Override
    public CassandraColumnType resolve(TypeInformation<?> typeInformation) {
        Assert.notNull(typeInformation, (String)"TypeInformation must not be null");
        CassandraColumnType cassandraColumnType = this.typeInformationColumnTypeCache.get(typeInformation);
        if (cassandraColumnType == null) {
            cassandraColumnType = this.resolve(typeInformation, FrozenIndicator.NOT_FROZEN);
            this.typeInformationColumnTypeCache.put(typeInformation, cassandraColumnType);
        }
        return cassandraColumnType;
    }

    private CassandraColumnType resolve(TypeInformation<?> typeInformation, FrozenIndicator frozen) {
        return this.getCustomWriteTarget(typeInformation).map(it -> this.createCassandraTypeDescriptor(this.tryResolve((Class<?>)it), TypeInformation.of((Class)it))).orElseGet(() -> typeInformation.getType().isEnum() ? ColumnType.create(String.class, DataTypes.TEXT) : this.createCassandraTypeDescriptor(typeInformation, frozen));
    }

    private Optional<Class<?>> getCustomWriteTarget(TypeInformation<?> typeInformation) {
        return this.customConversions.get().getCustomWriteTarget(typeInformation.getType());
    }

    private @Nullable DataType tryResolve(Class<?> type) {
        if (TupleValue.class.isAssignableFrom(type)) {
            return null;
        }
        if (UdtValue.class.isAssignableFrom(type)) {
            return null;
        }
        try {
            return this.getCodecRegistry().codecFor(type).getCqlType();
        }
        catch (CodecNotFoundException cause) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Cannot resolve Codec for %s", type.getName()), (Throwable)cause);
            }
            return null;
        }
    }

    public CassandraColumnType resolve(VectorType annotation) {
        DataType subtype = CassandraSimpleTypeHolder.getRequiredDataTypeFor(annotation.subtype());
        return this.createCassandraTypeDescriptor((DataType)DataTypes.vectorOf((DataType)subtype, (int)annotation.dimensions()));
    }

    @Override
    public CassandraColumnType resolve(CassandraType annotation) {
        CassandraType.Name type = annotation.type();
        return this.doGetColumnType(annotation, type);
    }

    private CassandraColumnType doGetColumnType(CassandraType annotation, CassandraType.Name type) {
        switch (type) {
            case MAP: {
                DefaultColumnTypeResolver.assertTypeArguments(annotation.typeArguments().length, 2);
                CassandraColumnType keyType = this.createCassandraTypeDescriptor(this.getRequiredDataType(annotation, 0));
                CassandraColumnType valueType = this.createCassandraTypeDescriptor(this.getRequiredDataType(annotation, 1));
                return ColumnType.mapOf(keyType, valueType);
            }
            case LIST: 
            case SET: {
                DefaultColumnTypeResolver.assertTypeArguments(annotation.typeArguments().length, 1);
                DataType componentType = this.getRequiredDataType(annotation, 0);
                if (type == CassandraType.Name.SET) {
                    return ColumnType.setOf(this.createCassandraTypeDescriptor(componentType));
                }
                return ColumnType.listOf(this.createCassandraTypeDescriptor(componentType));
            }
            case TUPLE: {
                DataType[] dataTypes = (DataType[])Arrays.stream(annotation.typeArguments()).map(dataTypeName -> this.doGetColumnType(annotation, (CassandraType.Name)((Object)dataTypeName)).getDataType()).toArray(DataType[]::new);
                return ColumnType.tupleOf(DataTypes.tupleOf((DataType[])dataTypes));
            }
            case UDT: {
                if (ObjectUtils.isEmpty((Object)annotation.userTypeName())) {
                    throw new InvalidDataAccessApiUsageException("Cannot resolve user type for @CassandraType(type=UDT) without userTypeName");
                }
                return this.createCassandraTypeDescriptor((DataType)this.getUserType(annotation.userTypeName()));
            }
        }
        return this.createCassandraTypeDescriptor(CassandraSimpleTypeHolder.getRequiredDataTypeFor(type));
    }

    @Override
    public ColumnType resolve(@Nullable Object value) {
        if (value != null) {
            TypeInformation typeInformation = TypeInformation.of(value.getClass());
            return this.getCustomWriteTarget(typeInformation).map(it -> this.createCassandraTypeDescriptor(this.tryResolve((Class<?>)it), typeInformation)).orElseGet(() -> {
                if (typeInformation.getType().isEnum()) {
                    return ColumnType.create(String.class, DataTypes.TEXT);
                }
                if (value instanceof Map) {
                    return ColumnType.mapOf(DefaultColumnType.OBJECT, DefaultColumnType.OBJECT);
                }
                if (value instanceof List) {
                    return ColumnType.listOf(DefaultColumnType.OBJECT);
                }
                if (value instanceof Set) {
                    return ColumnType.setOf(DefaultColumnType.OBJECT);
                }
                if (value instanceof UdtValue) {
                    return ColumnType.udtOf(((UdtValue)value).getType());
                }
                if (value instanceof TupleValue) {
                    return ColumnType.tupleOf(((TupleValue)value).getType());
                }
                CassandraPersistentEntity persistentEntity = (CassandraPersistentEntity)this.mappingContext.getPersistentEntity(typeInformation);
                if (persistentEntity != null && (persistentEntity.isUserDefinedType() || persistentEntity.isTupleType())) {
                    return this.resolve(persistentEntity.getTypeInformation());
                }
                return ColumnType.create(typeInformation.getType());
            });
        }
        return DefaultColumnType.OBJECT;
    }

    private CassandraColumnType createCassandraTypeDescriptor(DataType dataType) {
        GenericType javaType = this.getCodecRegistry().codecFor(dataType).getJavaType();
        return ColumnType.create(javaType.getRawType(), dataType);
    }

    private CassandraColumnType createCassandraTypeDescriptor(@Nullable DataType dataType, TypeInformation<?> typeInformation) {
        if (typeInformation.isCollectionLike() || typeInformation.isMap()) {
            if (dataType instanceof ListType) {
                TypeInformation component = typeInformation.getComponentType();
                DataType elementType = ((ListType)dataType).getElementType();
                if (component != null) {
                    return ColumnType.listOf(this.createCassandraTypeDescriptor(elementType, component));
                }
                Class<?> componentType = this.resolveToJavaType(elementType);
                return ColumnType.listOf(ColumnType.create(componentType, elementType));
            }
            if (dataType instanceof SetType) {
                TypeInformation component = typeInformation.getComponentType();
                DataType elementType = ((SetType)dataType).getElementType();
                if (component != null) {
                    return ColumnType.setOf(this.createCassandraTypeDescriptor(elementType, component));
                }
                Class<?> componentType = this.resolveToJavaType(elementType);
                return ColumnType.setOf(ColumnType.create(componentType, elementType));
            }
            if (dataType instanceof MapType) {
                TypeInformation mapKeyType = typeInformation.getComponentType();
                TypeInformation mapValueType = typeInformation.getMapValueType();
                MapType mapType = (MapType)dataType;
                CassandraColumnType keyDescriptor = null;
                CassandraColumnType valueDescriptor = null;
                if (mapKeyType != null) {
                    keyDescriptor = this.createCassandraTypeDescriptor(mapType.getKeyType(), mapKeyType);
                }
                if (mapValueType != null) {
                    valueDescriptor = this.createCassandraTypeDescriptor(mapType.getValueType(), mapValueType);
                }
                if (keyDescriptor == null) {
                    keyDescriptor = ColumnType.create(this.resolveToJavaType(mapType.getKeyType()), mapType.getKeyType());
                }
                if (valueDescriptor == null) {
                    valueDescriptor = ColumnType.create(this.resolveToJavaType(mapType.getValueType()), mapType.getValueType());
                }
                return ColumnType.mapOf(keyDescriptor, valueDescriptor);
            }
        }
        if (dataType == null) {
            return new UnresolvableCassandraType(typeInformation, new ColumnType[0]);
        }
        return new DefaultCassandraColumnType(typeInformation, dataType, new ColumnType[0]);
    }

    private CassandraColumnType createCassandraTypeDescriptor(TypeInformation<?> typeInformation, FrozenIndicator frozen) {
        if (List.class.isAssignableFrom(typeInformation.getType())) {
            return ColumnType.listOf(this.resolve(typeInformation.getRequiredComponentType(), frozen.getFrozen(0)), frozen.isFrozen());
        }
        if (Set.class.isAssignableFrom(typeInformation.getType())) {
            return ColumnType.setOf(this.resolve(typeInformation.getRequiredComponentType(), frozen.getFrozen(0)), frozen.isFrozen());
        }
        if (typeInformation.isMap()) {
            FrozenIndicator frozenKey = frozen.getFrozen(0);
            FrozenIndicator frozenValue = frozen.getFrozen(1);
            return ColumnType.mapOf(this.resolve(typeInformation.getRequiredComponentType(), frozenKey), this.resolve(typeInformation.getRequiredMapValueType(), frozenValue), frozen.isFrozen());
        }
        CassandraPersistentEntity persistentEntity = (CassandraPersistentEntity)this.mappingContext.getPersistentEntity(typeInformation);
        if (persistentEntity != null) {
            if (persistentEntity.isUserDefinedType()) {
                return new DefaultCassandraColumnType(typeInformation, (DataType)this.getUserType(persistentEntity, frozen.isFrozen()), new ColumnType[0]);
            }
            if (persistentEntity.isTupleType()) {
                DataType[] componentTypes = (DataType[])StreamSupport.stream(persistentEntity.spliterator(), false).map(this::resolve).map(CassandraColumnType::getDataType).toArray(DataType[]::new);
                return new DefaultCassandraColumnType(typeInformation, (DataType)DataTypes.tupleOf((DataType[])componentTypes), new ColumnType[0]);
            }
            return new UnresolvableCassandraType(typeInformation, new ColumnType[0]);
        }
        DataType dataType = this.tryResolve(typeInformation.getType());
        return dataType == null ? new UnresolvableCassandraType(typeInformation, new ColumnType[0]) : new DefaultCassandraColumnType(typeInformation, dataType, new ColumnType[0]);
    }

    private DataType getRequiredDataType(CassandraType annotation, int typeIndex) {
        CassandraType.Name typeName = annotation.typeArguments()[typeIndex];
        return typeName == CassandraType.Name.UDT ? this.getUserType(annotation.userTypeName()) : CassandraSimpleTypeHolder.getRequiredDataTypeFor(typeName);
    }

    private Class<?> resolveToJavaType(DataType dataType) {
        TypeCodec codec = this.getCodecRegistry().codecFor(dataType);
        return codec.getJavaType().getRawType();
    }

    private CodecRegistry getCodecRegistry() {
        return this.codecRegistry.get();
    }

    private UserDefinedType getUserType(CassandraPersistentEntity<?> persistentEntity, boolean frozen) {
        return (persistentEntity.hasKeyspace() ? this.getUserType(persistentEntity.getRequiredKeyspace(), persistentEntity.getTableName()) : this.getUserType(persistentEntity.getTableName())).copy(frozen);
    }

    private UserDefinedType getUserType(String userTypeName) {
        if (userTypeName.contains(".") && !userTypeName.contains("\"")) {
            String[] split = userTypeName.split("\\.");
            return this.getUserType(CqlIdentifier.fromCql((String)split[0]), CqlIdentifier.fromCql((String)split[1]));
        }
        return this.getUserType(CqlIdentifier.fromCql((String)userTypeName));
    }

    private UserDefinedType getUserType(CqlIdentifier userTypeName) {
        UserDefinedType type = this.userTypeResolver.resolveType(userTypeName);
        if (type == null) {
            throw new MappingException(String.format("User type [%s] not found", userTypeName));
        }
        return type;
    }

    private UserDefinedType getUserType(CqlIdentifier keyspace, CqlIdentifier userTypeName) {
        UserDefinedType type = this.userTypeResolver.resolveType(keyspace, userTypeName);
        if (type == null) {
            throw new MappingException(String.format("User type [%s] in keyspace [%s] not found", userTypeName, keyspace));
        }
        return type;
    }

    private static void assertTypeArguments(int args, int expected) {
        if (args != expected) {
            throw new InvalidDataAccessApiUsageException(String.format("Expected [%d] type arguments actual was [%d]", expected, args));
        }
    }

    static class UnresolvableCassandraType
    extends DefaultCassandraColumnType {
        public UnresolvableCassandraType(TypeInformation<?> type, ColumnType ... parameters) {
            super(type, (Supplier<DataType>)Lazy.empty(), parameters);
        }

        @Override
        public DataType getDataType() {
            throw new MappingException(String.format("Cannot resolve DataType for %s", this.getType().getName()));
        }

        @Override
        public boolean isTupleType() {
            return false;
        }

        @Override
        public boolean isUserDefinedType() {
            return false;
        }
    }
}

