/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.cassandra.config.KeyspaceAction;
import org.springframework.data.cassandra.config.KeyspaceActionSpecificationFactory;
import org.springframework.data.cassandra.config.KeyspaceActions;
import org.springframework.data.cassandra.core.cql.keyspace.DataCenterReplication;
import org.springframework.data.cassandra.core.cql.keyspace.KeyspaceActionSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.KeyspaceOption;
import org.springframework.util.Assert;

public class KeyspaceActionSpecificationFactoryBean
implements FactoryBean<KeyspaceActions>,
InitializingBean {
    private KeyspaceAction action = KeyspaceAction.NONE;
    private @Nullable String name;
    private List<String> networkTopologyDataCenters = new LinkedList<String>();
    private List<String> networkTopologyReplicationFactors = new LinkedList<String>();
    private KeyspaceOption.ReplicationStrategy replicationStrategy = KeyspaceOption.ReplicationStrategy.SIMPLE_STRATEGY;
    private int replicationFactor;
    private boolean durableWrites = false;
    private boolean ifNotExists = false;
    private @Nullable KeyspaceActions actions;

    public void afterPropertiesSet() {
        Assert.hasText((String)this.name, (String)"Keyspace name is required for a keyspace action");
        Assert.notNull((Object)((Object)this.action), (String)"Keyspace action is required for a keyspace action");
        KeyspaceActionSpecificationFactory.KeyspaceActionSpecificationFactoryBuilder builder = KeyspaceActionSpecificationFactory.builder(this.name).durableWrites(this.durableWrites);
        if (this.replicationStrategy == KeyspaceOption.ReplicationStrategy.SIMPLE_STRATEGY) {
            builder.simpleReplication(this.replicationFactor);
        }
        if (this.replicationStrategy == KeyspaceOption.ReplicationStrategy.NETWORK_TOPOLOGY_STRATEGY) {
            int i = 0;
            for (String datacenter : this.networkTopologyDataCenters) {
                builder.withDataCenter(DataCenterReplication.of(datacenter, Integer.parseInt(this.networkTopologyReplicationFactors.get(i++))));
            }
        }
        KeyspaceActionSpecificationFactory factory = builder.build();
        this.actions = this.createActions(factory);
    }

    private KeyspaceActions createActions(KeyspaceActionSpecificationFactory factory) {
        switch (this.action) {
            case NONE: {
                return new KeyspaceActions(new KeyspaceActionSpecification[0]);
            }
            case CREATE_DROP: {
                return new KeyspaceActions(factory.create(this.ifNotExists), factory.drop(this.ifNotExists));
            }
            case CREATE: {
                return new KeyspaceActions(factory.create(this.ifNotExists));
            }
            case ALTER: {
                return new KeyspaceActions(factory.alter());
            }
        }
        throw new IllegalStateException(String.format("KeyspaceAction %s not supported", new Object[]{this.action}));
    }

    public @Nullable KeyspaceActions getObject() {
        return this.actions;
    }

    public Class<?> getObjectType() {
        return Set.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public KeyspaceAction getAction() {
        return this.action;
    }

    public void setAction(KeyspaceAction action) {
        this.action = action;
    }

    public boolean isDurableWrites() {
        return this.durableWrites;
    }

    public void setDurableWrites(boolean durableWrites) {
        this.durableWrites = durableWrites;
    }

    public KeyspaceOption.ReplicationStrategy getReplicationStrategy() {
        return this.replicationStrategy;
    }

    public void setReplicationStrategy(KeyspaceOption.ReplicationStrategy replicationStrategy) {
        this.replicationStrategy = replicationStrategy;
    }

    public List<String> getNetworkTopologyDataCenters() {
        return this.networkTopologyDataCenters;
    }

    public void setNetworkTopologyDataCenters(List<String> networkTopologyDataCenters) {
        this.networkTopologyDataCenters = networkTopologyDataCenters;
    }

    public List<String> getNetworkTopologyReplicationFactors() {
        return this.networkTopologyReplicationFactors;
    }

    public void setNetworkTopologyReplicationFactors(List<String> networkTopologyReplicationFactors) {
        this.networkTopologyReplicationFactors = networkTopologyReplicationFactors;
    }

    public long getReplicationFactor() {
        return this.replicationFactor;
    }

    public void setReplicationFactor(int replicationFactor) {
        this.replicationFactor = replicationFactor;
    }
}

