/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import com.datastax.oss.driver.api.core.CqlSession;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.cql.CqlTemplate;
import org.springframework.data.cassandra.core.cql.session.DefaultSessionFactory;
import org.springframework.util.Assert;

public class CassandraCqlTemplateFactoryBean
implements FactoryBean<CqlTemplate>,
InitializingBean {
    private @Nullable CqlTemplate template;
    private @Nullable SessionFactory sessionFactory;

    public CqlTemplate getObject() {
        Assert.state((this.template != null ? 1 : 0) != 0, (String)"CqlTemplate has not been initialized");
        return this.template;
    }

    public Class<CqlTemplate> getObjectType() {
        return CqlTemplate.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.sessionFactory, (String)"SessionFactory must not be null");
        this.template = new CqlTemplate(this.sessionFactory);
    }

    public void setSession(CqlSession session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.setSessionFactory(new DefaultSessionFactory(session));
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"SessionFactory must not be null");
        this.sessionFactory = sessionFactory;
    }
}

