/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.cassandra.core.EntityOperations;

class OptimisticLockingUtils {
    OptimisticLockingUtils() {
    }

    public static OptimisticLockingFailureException insertFailed(EntityOperations.AdaptibleEntity<?> entity) {
        return new OptimisticLockingFailureException(String.format("Failed to insert versioned entity with id '%s' (version '%s') in table [%s]; Row already exists.", entity.getIdentifier(), entity.getVersion(), entity.getPersistentEntity().getTableName()));
    }

    public static OptimisticLockingFailureException updateFailed(EntityOperations.AdaptibleEntity<?> entity) {
        return new OptimisticLockingFailureException(String.format("Failed to update versioned entity with id '%s' (version '%s') in table [%s]; Was the entity updated or deleted concurrently?", entity.getIdentifier(), entity.getVersion(), entity.getPersistentEntity().getTableName()));
    }

    public static OptimisticLockingFailureException deleteFailed(EntityOperations.AdaptibleEntity<?> entity) {
        return new OptimisticLockingFailureException(String.format("Failed to delete versioned entity with id '%s' (version '%s') in table [%s]; Was the entity updated or deleted concurrently?", entity.getIdentifier(), entity.getVersion(), entity.getPersistentEntity().getTableName()));
    }
}

