/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.oss.driver.api.core.data.CqlVector;
import org.springframework.data.domain.Vector;
import org.springframework.util.Assert;

public class CassandraVector
implements Vector {
    private final CqlVector<?> cqlVector;

    private CassandraVector(CqlVector<?> cqlVector) {
        this.cqlVector = cqlVector;
    }

    public static CassandraVector of(CqlVector<?> cqlVector) {
        Assert.notNull(cqlVector, (String)"CqlVector must not be null");
        return new CassandraVector(cqlVector);
    }

    public Class<? extends Number> getType() {
        if (!this.cqlVector.isEmpty()) {
            Object o = this.cqlVector.get(0);
            if (o instanceof Float) {
                return Float.class;
            }
            if (o instanceof Double) {
                return Double.class;
            }
        }
        return Number.class;
    }

    public CqlVector<?> getSource() {
        return this.cqlVector;
    }

    public int size() {
        return this.cqlVector.size();
    }

    public float[] toFloatArray() {
        float[] v = new float[this.cqlVector.size()];
        for (int i = 0; i < this.cqlVector.size(); ++i) {
            v[i] = ((Number)this.cqlVector.get(i)).floatValue();
        }
        return v;
    }

    public double[] toDoubleArray() {
        double[] v = new double[this.cqlVector.size()];
        for (int i = 0; i < this.cqlVector.size(); ++i) {
            v[i] = ((Number)this.cqlVector.get(i)).doubleValue();
        }
        return v;
    }

    public String toString() {
        return this.cqlVector.toString();
    }
}

