/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.data.cassandra.CassandraManagedTypes;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.config.AbstractSessionConfiguration;
import org.springframework.data.cassandra.config.CassandraEntityClassScanner;
import org.springframework.data.cassandra.config.SchemaAction;
import org.springframework.data.cassandra.config.SessionFactoryFactoryBean;
import org.springframework.data.cassandra.core.CassandraAdminTemplate;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.CassandraCustomConversions;
import org.springframework.data.cassandra.core.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.cql.session.init.KeyspacePopulator;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.SimpleTupleTypeFactory;
import org.springframework.data.cassandra.core.mapping.SimpleUserTypeResolver;
import org.springframework.data.cassandra.core.mapping.UserTypeResolver;
import org.springframework.data.convert.CustomConversions;
import org.springframework.lang.Nullable;

@Configuration
public abstract class AbstractCassandraConfiguration
extends AbstractSessionConfiguration
implements BeanClassLoaderAware {
    @Nullable
    private ClassLoader beanClassLoader;

    @Bean
    public CassandraConverter cassandraConverter() {
        CqlSession cqlSession = this.getRequiredSession();
        MappingCassandraConverter converter = new MappingCassandraConverter(this.requireBeanOfType(CassandraMappingContext.class));
        converter.setCodecRegistry(cqlSession.getContext().getCodecRegistry());
        converter.setUserTypeResolver(this.userTypeResolver(cqlSession));
        converter.setCustomConversions(this.requireBeanOfType(CassandraCustomConversions.class));
        return converter;
    }

    @Bean
    public CassandraManagedTypes cassandraManagedTypes() throws ClassNotFoundException {
        return CassandraManagedTypes.fromIterable(this.getInitialEntitySet());
    }

    @Deprecated(since="4.0", forRemoval=true)
    public CassandraMappingContext cassandraMapping() throws ClassNotFoundException {
        return this.cassandraMappingContext(this.cassandraManagedTypes());
    }

    @Bean
    public CassandraMappingContext cassandraMappingContext(CassandraManagedTypes cassandraManagedTypes) {
        CqlSession cqlSession = this.getRequiredSession();
        CassandraMappingContext mappingContext = new CassandraMappingContext(this.userTypeResolver(cqlSession), SimpleTupleTypeFactory.DEFAULT);
        CustomConversions customConversions = this.requireBeanOfType(CassandraCustomConversions.class);
        this.getBeanClassLoader().ifPresent(mappingContext::setBeanClassLoader);
        mappingContext.setCodecRegistry(cqlSession.getContext().getCodecRegistry());
        mappingContext.setCustomConversions(customConversions);
        mappingContext.setManagedTypes(cassandraManagedTypes);
        mappingContext.setSimpleTypeHolder(customConversions.getSimpleTypeHolder());
        return mappingContext;
    }

    @Bean
    public SessionFactoryFactoryBean cassandraSessionFactory(CqlSession cqlSession) {
        SessionFactoryFactoryBean bean = new SessionFactoryFactoryBean();
        bean.setSession(cqlSession);
        bean.setConverter(this.requireBeanOfType(CassandraConverter.class));
        bean.setKeyspaceCleaner(this.keyspaceCleaner());
        bean.setKeyspacePopulator(this.keyspacePopulator());
        bean.setSchemaAction(this.getSchemaAction());
        return bean;
    }

    @Bean
    public CassandraAdminTemplate cassandraTemplate() {
        return new CassandraAdminTemplate(this.getRequiredSessionFactory(), this.requireBeanOfType(CassandraConverter.class));
    }

    @Bean
    public CassandraCustomConversions customConversions() {
        return CassandraCustomConversions.create(config -> {});
    }

    public void setBeanClassLoader(@Nullable ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    protected Optional<ClassLoader> getBeanClassLoader() {
        return Optional.ofNullable(this.beanClassLoader);
    }

    public String[] getEntityBasePackages() {
        return new String[]{this.getClass().getPackage().getName()};
    }

    protected Set<Class<?>> getInitialEntitySet() throws ClassNotFoundException {
        CassandraEntityClassScanner scanner = new CassandraEntityClassScanner();
        scanner.setBeanClassLoader(this.beanClassLoader);
        scanner.setEntityBasePackages(Arrays.asList(this.getEntityBasePackages()));
        return scanner.scanForEntityClasses();
    }

    @Override
    protected SessionFactory getRequiredSessionFactory() {
        return this.requireBeanOfType(SessionFactory.class);
    }

    public SchemaAction getSchemaAction() {
        return SchemaAction.NONE;
    }

    @Nullable
    protected KeyspacePopulator keyspaceCleaner() {
        return null;
    }

    @Nullable
    protected KeyspacePopulator keyspacePopulator() {
        return null;
    }

    protected ByteArrayResource scriptOf(String content) {
        return new ByteArrayResource(content.getBytes());
    }

    protected UserTypeResolver userTypeResolver(CqlSession cqlSession) {
        return new SimpleUserTypeResolver(cqlSession, CqlIdentifier.fromCql((String)this.getKeyspaceName()));
    }
}

