/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.keyspace;

import java.util.Map;
import org.springframework.data.cassandra.core.cql.keyspace.DataCenterReplication;
import org.springframework.data.cassandra.core.cql.keyspace.DefaultOption;
import org.springframework.data.cassandra.core.cql.keyspace.KeyspaceOption;
import org.springframework.data.cassandra.core.cql.keyspace.Option;
import org.springframework.data.cassandra.util.MapBuilder;

public class KeyspaceAttributes {
    public static final KeyspaceOption.ReplicationStrategy DEFAULT_REPLICATION_STRATEGY = KeyspaceOption.ReplicationStrategy.SIMPLE_STRATEGY;
    public static final long DEFAULT_REPLICATION_FACTOR = 1L;
    public static final boolean DEFAULT_DURABLE_WRITES = true;
    private KeyspaceOption.ReplicationStrategy replicationStrategy = DEFAULT_REPLICATION_STRATEGY;
    private long replicationFactor = 1L;
    private boolean durableWrites = true;

    public static Map<Option, Object> newSimpleReplication() {
        return KeyspaceAttributes.newSimpleReplication(1L);
    }

    public static Map<Option, Object> newSimpleReplication(long replicationFactor) {
        return MapBuilder.map(Option.class, Object.class).entry(new DefaultOption("class", String.class, true, false, true), KeyspaceOption.ReplicationStrategy.SIMPLE_STRATEGY.getValue()).entry(new DefaultOption("replication_factor", Long.class, true, false, false), replicationFactor).build();
    }

    public static Map<Option, Object> newNetworkReplication(DataCenterReplication ... dataCenterReplications) {
        MapBuilder<Option, Object> builder = MapBuilder.map(Option.class, Object.class).entry(new DefaultOption("class", String.class, true, false, true), KeyspaceOption.ReplicationStrategy.NETWORK_TOPOLOGY_STRATEGY.getValue());
        for (DataCenterReplication dcr : dataCenterReplications) {
            builder.entry(new DefaultOption(dcr.getDataCenter(), Long.class, true, false, false), dcr.getReplicationFactor());
        }
        return builder.build();
    }

    public KeyspaceOption.ReplicationStrategy getReplicationStrategy() {
        return this.replicationStrategy;
    }

    public void setReplicationStrategy(KeyspaceOption.ReplicationStrategy replicationStrategy) {
        this.replicationStrategy = replicationStrategy;
    }

    public long getReplicationFactor() {
        return this.replicationFactor;
    }

    public void setReplicationFactor(long replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    public boolean getDurableWrites() {
        return this.durableWrites;
    }

    public void setDurableWrites(boolean durableWrites) {
        this.durableWrites = durableWrites;
    }
}

