/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.generator;

import org.springframework.data.cassandra.core.cql.generator.AlterKeyspaceCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.AlterTableCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.AlterUserTypeCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.CreateIndexCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.CreateKeyspaceCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.CreateTableCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.CreateUserTypeCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.DropIndexCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.DropKeyspaceCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.DropTableCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.DropUserTypeCqlGenerator;
import org.springframework.data.cassandra.core.cql.keyspace.AlterKeyspaceSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.AlterTableSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.AlterUserTypeSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CqlSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CreateIndexSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CreateKeyspaceSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CreateTableSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CreateUserTypeSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.DropIndexSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.DropKeyspaceSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.DropTableSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.DropUserTypeSpecification;

public final class CqlGenerator {
    private CqlGenerator() {
    }

    public static String toCql(CqlSpecification specification) {
        if (specification instanceof CreateKeyspaceSpecification) {
            CreateKeyspaceSpecification createKeyspace = (CreateKeyspaceSpecification)specification;
            return CreateKeyspaceCqlGenerator.toCql(createKeyspace);
        }
        if (specification instanceof AlterKeyspaceSpecification) {
            AlterKeyspaceSpecification alterKeyspace = (AlterKeyspaceSpecification)specification;
            return AlterKeyspaceCqlGenerator.toCql(alterKeyspace);
        }
        if (specification instanceof DropKeyspaceSpecification) {
            DropKeyspaceSpecification dropKeyspace = (DropKeyspaceSpecification)specification;
            return DropKeyspaceCqlGenerator.toCql(dropKeyspace);
        }
        if (specification instanceof CreateTableSpecification) {
            CreateTableSpecification createTable = (CreateTableSpecification)specification;
            return CreateTableCqlGenerator.toCql(createTable);
        }
        if (specification instanceof AlterTableSpecification) {
            AlterTableSpecification alterTable = (AlterTableSpecification)specification;
            return AlterTableCqlGenerator.toCql(alterTable);
        }
        if (specification instanceof DropTableSpecification) {
            DropTableSpecification dropTable = (DropTableSpecification)specification;
            return DropTableCqlGenerator.toCql(dropTable);
        }
        if (specification instanceof CreateUserTypeSpecification) {
            CreateUserTypeSpecification createType = (CreateUserTypeSpecification)specification;
            return CreateUserTypeCqlGenerator.toCql(createType);
        }
        if (specification instanceof AlterUserTypeSpecification) {
            AlterUserTypeSpecification alterType = (AlterUserTypeSpecification)specification;
            return AlterUserTypeCqlGenerator.toCql(alterType);
        }
        if (specification instanceof DropUserTypeSpecification) {
            DropUserTypeSpecification dropType = (DropUserTypeSpecification)specification;
            return DropUserTypeCqlGenerator.toCql(dropType);
        }
        if (specification instanceof CreateIndexSpecification) {
            CreateIndexSpecification createIndex = (CreateIndexSpecification)specification;
            return CreateIndexCqlGenerator.toCql(createIndex);
        }
        if (specification instanceof DropIndexSpecification) {
            DropIndexSpecification dropIndex = (DropIndexSpecification)specification;
            return DropIndexCqlGenerator.toCql(dropIndex);
        }
        throw new UnsupportedOperationException(String.format("CQL specification %s is not supported", specification));
    }
}

